/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.common;

import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.SpellcheckedTextProvider;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPropsPreferencePage;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.PropertyNameVerifier;

public class EditCustomPropertiesPanel
extends AbstractDialogPanel {
    protected ModelBusTeamPropsPreferencePage.CustomProperty property;
    protected Text propName;
    protected Text propRegexp;
    protected StyledText propDescription;

    public EditCustomPropertiesPanel(ModelBusTeamPropsPreferencePage.CustomProperty property) {
        this.property = property;
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource(property == null ? "EditCustomPropertiesPanel.Title.Add" : "EditAutoPropertiesPanel.Title.Edit");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Message");
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        parent.setLayout((Layout)layout);
        Label propNameLabel = new Label(parent, 0);
        propNameLabel.setText(ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropName"));
        this.propName = new Text(parent, 2048);
        this.propName.setText(this.property == null ? "" : this.property.propName);
        GridData layoutData = new GridData(768);
        this.propName.setLayoutData((Object)layoutData);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropName.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new PropertyNameVerifier(name));
        this.attachTo((Control)this.propName, verifier);
        Group optional = new Group(parent, 0);
        optional.setText(ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Optional"));
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        optional.setLayoutData((Object)layoutData);
        layout = new GridLayout();
        layout.numColumns = 1;
        optional.setLayout((Layout)layout);
        Label propRegexpLabel = new Label((Composite)optional, 0);
        propRegexpLabel.setText(ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropRegExp"));
        this.propRegexp = new Text((Composite)optional, 2048);
        this.propRegexp.setText(this.property == null ? "" : this.property.regExp);
        layoutData = new GridData(768);
        this.propRegexp.setLayoutData((Object)layoutData);
        this.attachTo((Control)this.propRegexp, new AbstractFormattedVerifier("EditCustomProperty.Regexp"){

            @Override
            protected String getErrorMessageImpl(Control input) {
                try {
                    Pattern.compile(this.getText(input));
                }
                catch (Exception exception) {
                    return ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.Validator.RegExp");
                }
                return null;
            }

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
        Label propDescriptionLabel = new Label((Composite)optional, 0);
        propDescriptionLabel.setText(ModelBusTeamUIPlugin.instance().getResource("EditCustomPropertiesPanel.PropDescription"));
        layoutData = new GridData();
        propDescriptionLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(1808);
        layoutData.heightHint = 80;
        layoutData.widthHint = 0;
        this.propDescription = SpellcheckedTextProvider.getTextWidget((Composite)optional, layoutData, 578);
        this.propDescription.setText(this.property == null ? "" : this.property.descriprion);
    }

    public ModelBusTeamPropsPreferencePage.CustomProperty getProperty() {
        return this.property;
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        if (this.property == null) {
            this.property = new ModelBusTeamPropsPreferencePage.CustomProperty(this.propName.getText(), this.propRegexp.getText(), this.propDescription.getText());
        } else {
            this.property.propName = this.propName.getText();
            this.property.regExp = this.propRegexp.getText();
            this.property.descriprion = this.propDescription.getText();
        }
    }
}

