/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.common;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.resource.IRepositoryBase;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.RepositoryTreeComposite;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.repository.model.IParentTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.IResourceTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFictiveNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFolder;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryLocationFilter;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryResource;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryRevisions;

public class RepositoryTreePanel
extends AbstractDialogPanel {
    protected RepositoryTreeComposite repositoryTree;
    protected IRepositoryBase root;
    protected IRepositoryResource selectedResource;
    protected IRepositoryResource[] selectedResources;
    protected boolean allowSourcesInTree;
    protected boolean allowFiles;
    protected boolean autoExpandFirstLevel;

    public RepositoryTreePanel(String title, IRepositoryResource[] resources, boolean allowSourcesInTree) {
        this(title, ModelBusTeamUIPlugin.instance().getResource("RepositoryTreePanel.Description"), AbstractDialogPanel.makeToBeOperatedMessage(resources), resources, allowSourcesInTree);
    }

    public RepositoryTreePanel(String title, String description, String message, IRepositoryResource[] resources, boolean allowSourcesInTree) {
        this(title, description, message, resources, allowSourcesInTree, null);
    }

    public void setAutoExpandFirstLevel(boolean autoExpandFirstLevel) {
        this.autoExpandFirstLevel = autoExpandFirstLevel;
    }

    public RepositoryTreePanel(String title, String description, String message, IRepositoryResource[] resources, boolean allowSourcesInTree, IRepositoryBase root) {
        this.dialogTitle = title;
        this.dialogDescription = description;
        this.defaultMessage = message;
        this.selectedResources = resources;
        this.allowSourcesInTree = allowSourcesInTree;
        this.allowFiles = false;
        this.root = root;
    }

    public boolean isAllowFiles() {
        return this.allowFiles;
    }

    public void setAllowFiles(boolean allowFiles) {
        this.allowFiles = allowFiles;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        this.repositoryTree = this.root != null ? new RepositoryTreeComposite(parent, 2048, false, this.root) : (this.selectedResources.length > 0 ? new RepositoryTreeComposite(parent, 2048, false, new ProjectRoot(this.selectedResources[0])) : new RepositoryTreeComposite(parent, 2048));
        this.repositoryTree.setAutoExpandFirstLevel(this.autoExpandFirstLevel);
        if (this.repositoryTree.getRepositoryTreeViewer().getInput() instanceof ProjectRoot) {
            ProjectRoot root = (ProjectRoot)this.repositoryTree.getRepositoryTreeViewer().getInput();
            this.repositoryTree.getRepositoryTreeViewer().setExpandedElements(new Object[]{root.getChildren(null)[0]});
        }
        if (this.root == null && this.selectedResources.length > 0) {
            String url = ModelBusConnector.getRepositoryRootUrl();
            this.repositoryTree.setFilter(new RepositoryLocationFilter(url){

                @Override
                public boolean accept(Object obj) {
                    if (obj instanceof RepositoryFile && !RepositoryTreePanel.this.allowFiles || obj instanceof RepositoryRevisions || obj instanceof RepositoryFolder && RepositoryTreePanel.this.isSource(((RepositoryFolder)obj).getRepositoryResource())) {
                        return false;
                    }
                    return super.accept(obj);
                }
            });
        }
        GridData data = new GridData(1808);
        data.heightHint = 185;
        this.repositoryTree.setLayoutData(data);
        this.repositoryTree.getRepositoryTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RepositoryTreePanel.this.manager != null) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryTreePanel.this.repositoryTree.getRepositoryTreeViewer().getSelection();
                    RepositoryTreePanel.this.manager.setButtonEnabled(0, !selection.isEmpty() && selection.getFirstElement() instanceof IResourceTreeNode);
                }
            }
        });
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.copyMoveToDialogContext";
    }

    @Override
    protected void saveChangesImpl() {
        IStructuredSelection selection = (IStructuredSelection)this.repositoryTree.getRepositoryTreeViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof RepositoryResource) {
            this.selectedResource = ((IResourceTreeNode)selection.getFirstElement()).getRepositoryResource();
        }
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected boolean isSource(IRepositoryResource resource) {
        if (!this.allowSourcesInTree) {
            int i = 0;
            while (i < this.selectedResources.length) {
                if (resource.equals(this.selectedResources[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static class ProjectRoot
    extends RepositoryFictiveNode
    implements IParentTreeNode {
        protected RepositoryResource[] children;

        public ProjectRoot(IRepositoryResource resource) {
            IRepositoryRoot projectRoot = ModelBusUtility.getTrunkLocation((IRepositoryResource)resource);
            if (projectRoot.getKind() == 1) {
                projectRoot = projectRoot.getParent();
            }
            System.out.println("CHECKMWA34");
            this.children = new RepositoryResource[]{RepositoryFolder.wrapChild(null, (IRepositoryResource)projectRoot), RepositoryFolder.wrapChild(null, (IRepositoryResource)ModelBusConnector.getRepositoryRoot())};
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return this.children;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return null;
        }
    }
}

