/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.connector.ModelBusRevisionRange;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.GetLogMessagesOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.history.IModelBusHistoryViewInfo;
import org.modelbus.team.eclipse.ui.history.LogMessagesComposite;
import org.modelbus.team.eclipse.ui.history.ModelBusHistoryPage;
import org.modelbus.team.eclipse.ui.history.data.ModelBusLocalFileRevision;
import org.modelbus.team.eclipse.ui.history.filter.AuthorNameLogEntryFilter;
import org.modelbus.team.eclipse.ui.history.filter.ChangeNameLogEntryFilter;
import org.modelbus.team.eclipse.ui.history.filter.CommentLogEntryFilter;
import org.modelbus.team.eclipse.ui.history.filter.CompositeLogEntryFilter;
import org.modelbus.team.eclipse.ui.history.filter.ILogEntryFilter;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.panel.view.HistoryFilterPanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class SelectRevisionPanel
extends AbstractDialogPanel
implements IModelBusHistoryViewInfo {
    protected LogMessagesComposite history;
    protected ModelBusLogEntry[] logMessages;
    protected IRepositoryResource resource;
    protected ModelBusRevision currentRevision;
    protected boolean multiSelect;
    protected boolean useCheckboxes;
    protected long limit;
    protected boolean pagingEnabled;
    protected ModelBusLogEntry[] selectedLogMessages;
    protected Text resourceLabel;
    protected ToolItem hideUnrelatedItem;
    protected ToolItem stopOnCopyItem;
    protected ToolItem pagingItem;
    protected ToolItem pagingAllItem;
    protected ToolItem filterItem;
    protected ToolItem clearFilterItem;
    protected ToolItem refreshItem;
    protected ToolItem groupByDateItem;
    protected CommentLogEntryFilter commentFilter;
    protected AuthorNameLogEntryFilter authorFilter;
    protected ChangeNameLogEntryFilter changeFilter;
    protected CompositeLogEntryFilter logEntriesFilter;
    protected ISelectionChangedListener tableViewerListener;
    protected IPropertyChangeListener configurationListener;
    protected boolean initialStopOnCopy;
    protected boolean pending;

    public SelectRevisionPanel(GetLogMessagesOperation msgOp, boolean multiSelect, boolean useCheckboxes, ModelBusRevision currentRevision) {
        this.multiSelect = multiSelect;
        this.useCheckboxes = useCheckboxes;
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.Message");
        this.resource = msgOp.getResource();
        this.currentRevision = currentRevision;
        this.logMessages = msgOp.getMessages();
        this.initialStopOnCopy = msgOp.getStopOnCopy();
        this.authorFilter = new AuthorNameLogEntryFilter();
        this.commentFilter = new CommentLogEntryFilter();
        this.changeFilter = new ChangeNameLogEntryFilter();
        this.logEntriesFilter = new CompositeLogEntryFilter(new ILogEntryFilter[]{this.authorFilter, this.commentFilter, this.changeFilter});
    }

    public static GetLogMessagesOperation getMsgsOp(IRepositoryResource resource, boolean stopOnCopy) {
        GetLogMessagesOperation msgsOp = new GetLogMessagesOperation(resource, stopOnCopy);
        msgsOp.setIncludeMerged(ModelBusTeamPreferences.getMergeBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        if (ModelBusTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            msgsOp.setLimit((long)ModelBusTeamPreferences.getHistoryInt(store, "pageSize"));
        }
        return msgsOp;
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.revisionLinkDialogContext";
    }

    public String getSelectedRevision() {
        return this.selectedLogMessages[0].revision;
    }

    public ModelBusLogEntry[] getSelectedLogMessages() {
        return this.selectedLogMessages;
    }

    public ModelBusRevisionRange[] getSelectedRevisions() {
        ArrayList<ModelBusRevisionRange> revisions = new ArrayList<ModelBusRevisionRange>();
        List<ModelBusLogEntry> selected = Arrays.asList(this.selectedLogMessages);
        ModelBusRevision startRev = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
        ModelBusRevision lastRev = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
        ModelBusLogEntry[] modelBusLogEntryArray = this.logMessages;
        int n = this.logMessages.length;
        int n2 = 0;
        while (n2 < n) {
            ModelBusLogEntry entry = modelBusLogEntryArray[n2];
            if (selected.indexOf(entry) != -1) {
                lastRev = entry.modelBusRevision;
                if (startRev == ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
                    startRev = entry.modelBusRevision;
                }
            } else if (startRev != ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
                revisions.add(new ModelBusRevisionRange(startRev, lastRev));
                startRev = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
            }
            ++n2;
        }
        return revisions.toArray(new ModelBusRevisionRange[revisions.size()]);
    }

    @Override
    public String getImagePath() {
        return "icons/dialogs/select_revision.gif";
    }

    @Override
    public void postInit() {
        this.manager.setButtonEnabled(0, false);
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(700, -1);
    }

    @Override
    public boolean isGrouped() {
        return this.groupByDateItem.getSelection();
    }

    @Override
    public ModelBusRevision getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public IRepositoryResource getRepositoryResource() {
        return this.resource;
    }

    @Override
    public ModelBusLogEntry[] getRemoteHistory() {
        return ModelBusHistoryPage.filterMessages(this.logMessages, this.logEntriesFilter);
    }

    @Override
    public ModelBusLocalFileRevision[] getLocalHistory() {
        return null;
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    public int getMode() {
        return 128;
    }

    @Override
    public boolean isRelatedPathsOnly() {
        return this.hideUnrelatedItem.getSelection();
    }

    @Override
    public boolean isPending() {
        return this.pending;
    }

    public void addFilter(ILogEntryFilter filter) {
        this.logEntriesFilter.addFilter(filter);
    }

    public void removeFilter(ILogEntryFilter filter) {
        this.logEntriesFilter.removeFilter(filter);
    }

    @Override
    public void createControlsImpl(Composite parent) {
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        Composite labelAndToolbar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        labelAndToolbar.setLayout((Layout)layout);
        GridData data = new GridData(768);
        labelAndToolbar.setLayoutData((Object)data);
        Composite resourceLabelComposite = new Composite(labelAndToolbar, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resourceLabelComposite.setLayout((Layout)layout);
        resourceLabelComposite.setLayoutData((Object)data);
        this.resourceLabel = new Text(resourceLabelComposite, 16384);
        this.resourceLabel.setEditable(false);
        data = new GridData(770);
        this.resourceLabel.setLayoutData((Object)data);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl(labelAndToolbar);
        data = new GridData();
        data.horizontalAlignment = 3;
        toolBar.setLayoutData((Object)data);
        this.refreshItem = new ToolItem(toolBar, 0x800000);
        new ToolItem(toolBar, 2);
        this.groupByDateItem = new ToolItem(toolBar, 0x800020);
        new ToolItem(toolBar, 2);
        this.hideUnrelatedItem = new ToolItem(toolBar, 0x800020);
        this.stopOnCopyItem = new ToolItem(toolBar, 0x800020);
        new ToolItem(toolBar, 2);
        this.filterItem = new ToolItem(toolBar, 0x800000);
        this.clearFilterItem = new ToolItem(toolBar, 0x800000);
        new ToolItem(toolBar, 2);
        this.pagingItem = new ToolItem(toolBar, 0x800000);
        this.pagingAllItem = new ToolItem(toolBar, 0x800000);
        this.groupByDateItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/group_by_date.gif").createImage());
        this.hideUnrelatedItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/hide_unrelated.gif").createImage());
        this.stopOnCopyItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/stop_on_copy.gif").createImage());
        this.stopOnCopyItem.setSelection(this.initialStopOnCopy);
        this.filterItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/filter.gif").createImage());
        this.clearFilterItem.setDisabledImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear.gif").createImage());
        this.clearFilterItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear_filter.gif").createImage());
        this.pagingItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging.gif").createImage());
        this.pagingAllItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging_all.gif").createImage());
        this.refreshItem.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif").createImage());
        this.hideUnrelatedItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.Unrelated"));
        this.stopOnCopyItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.StopOnCopy"));
        this.filterItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.QuickFilter"));
        this.clearFilterItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.ClearFilter"));
        this.pagingAllItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowAll"));
        this.refreshItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.Refresh"));
        Composite group = new Composite(parent, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.history = new LogMessagesComposite(group, this.multiSelect, this.useCheckboxes, this);
        data = new GridData(1808);
        data.heightHint = 350;
        this.history.setLayoutData(data);
        this.history.setFocus();
        this.tableViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectRevisionPanel.this.manager != null) {
                    ModelBusLogEntry[] messages = SelectRevisionPanel.this.history.getSelectedLogMessages();
                    SelectRevisionPanel.this.manager.setButtonEnabled(0, messages != null && messages.length > 0);
                }
            }
        };
        this.history.getTreeViewer().addSelectionChangedListener(this.tableViewerListener);
        int type = ModelBusTeamPreferences.getHistoryInt(store, "groupingType");
        if (ModelBusTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            this.limit = ModelBusTeamPreferences.getHistoryInt(store, "pageSize");
            String msg = ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowNextX", new String[]{String.valueOf(this.limit)});
            this.pagingItem.setToolTipText(msg);
            this.pagingEnabled = true;
        } else {
            this.limit = 0L;
            this.pagingItem.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowNextPage"));
            this.pagingEnabled = false;
        }
        this.pagingEnabled = this.limit > 0L && (long)this.logMessages.length == this.limit;
        this.setPagingEnabled();
        this.clearFilterItem.setEnabled(false);
        this.groupByDateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.history.refresh(2);
            }
        });
        this.groupByDateItem.setSelection(type == 1);
        this.hideUnrelatedItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.history.refresh(1);
            }
        });
        this.stopOnCopyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.refresh();
            }
        });
        this.filterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.setFilter();
            }
        });
        this.clearFilterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.clearFilter();
            }
        });
        this.pagingItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.showNextPage(false);
            }
        });
        this.pagingAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.showNextPage(true);
            }
        });
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.refresh();
            }
        });
        this.pending = false;
        this.history.refresh(3);
        CheckboxTreeViewer treeTable = this.history.getTreeViewer();
        TreeItem firstItem = treeTable.getTree().getItem(0);
        if (((ILogNode)firstItem.getData()).getType() == 1) {
            firstItem = firstItem.getItem(0);
        }
        treeTable.getTree().setSelection(firstItem);
        this.history.refresh(1);
        this.showResourceLabel();
    }

    protected void showResourceLabel() {
        String resourceName = ModelBusTeamUIPlugin.instance().getResource("SelectRevisionPanel.NotSelected");
        if (this.resource != null) {
            resourceName = this.resource.getUrl();
        }
        this.resourceLabel.setText(resourceName);
    }

    @Override
    protected void saveChangesImpl() {
        this.selectedLogMessages = this.history.getSelectedLogMessages();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected void addPage(ModelBusLogEntry[] newMessages) {
        if (this.logMessages == null) {
            this.pending = false;
            this.logMessages = newMessages.length > 0 ? newMessages : null;
            this.pagingEnabled = this.limit > 0L && (long)newMessages.length == this.limit;
        } else if (newMessages.length > 1) {
            LinkedHashSet<ModelBusLogEntry> entries = new LinkedHashSet<ModelBusLogEntry>(Arrays.asList(this.logMessages));
            int oldSize = entries.size();
            entries.addAll(Arrays.asList(newMessages));
            this.logMessages = entries.toArray(new ModelBusLogEntry[entries.size()]);
            this.pagingEnabled = this.limit > 0L && ((long)newMessages.length == this.limit + 1L || entries.size() - oldSize < newMessages.length - 1);
        }
    }

    protected void setPagingEnabled() {
        this.pagingEnabled &= this.resource != null && this.limit > 0L;
        this.pagingItem.setEnabled(this.pagingEnabled);
        this.pagingAllItem.setEnabled(this.pagingEnabled);
        this.filterItem.setEnabled(this.resource != null && this.logMessages != null);
        this.clearFilterItem.setEnabled(this.isFilterEnabled() && this.logMessages != null);
    }

    protected void fetchHistory(final GetLogMessagesOperation msgsOp) {
        msgsOp.setIncludeMerged(ModelBusTeamPreferences.getMergeBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        final IStructuredSelection selected = (IStructuredSelection)this.history.getTreeViewer().getSelection();
        AbstractActionOperation showOp = new AbstractActionOperation("Operation.ShowMessages"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ModelBusTeamUIPlugin.instance().getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (msgsOp.getExecutionState() != 0) {
                            (this).SelectRevisionPanel.this.pending = false;
                            (this).SelectRevisionPanel.this.history.refresh(3);
                            return;
                        }
                        SelectRevisionPanel.this.addPage(msgsOp.getMessages());
                        (this).SelectRevisionPanel.this.history.refresh(3);
                        SelectRevisionPanel.this.setPagingEnabled();
                        CheckboxTreeViewer treeTable = (this).SelectRevisionPanel.this.history.getTreeViewer();
                        if (!treeTable.getTree().isDisposed() && treeTable.getTree().getItems().length > 0) {
                            if (selected.size() != 0) {
                                treeTable.setSelection((ISelection)selected);
                            } else {
                                TreeItem firstItem = treeTable.getTree().getItem(0);
                                if (((ILogNode)firstItem.getData()).getType() == 1) {
                                    firstItem = firstItem.getItem(0);
                                }
                                treeTable.getTree().setSelection(firstItem);
                            }
                            (this).SelectRevisionPanel.this.history.refresh(1);
                            ISelectionChangedListener listener = (this).SelectRevisionPanel.this.tableViewerListener;
                            if (listener != null) {
                                (this).SelectRevisionPanel.this.tableViewerListener.selectionChanged(null);
                            }
                        }
                    }
                });
            }
        };
        CompositeOperation op = new CompositeOperation(showOp.getId());
        op.add((IActionOperation)msgsOp);
        op.add((IActionOperation)showOp);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
    }

    protected void showNextPage(boolean showAll) {
        if (this.resource != null) {
            GetLogMessagesOperation msgsOp = new GetLogMessagesOperation(this.resource, this.stopOnCopyItem.getSelection());
            msgsOp.setLimit(showAll ? 0L : (this.logMessages == null ? this.limit : this.limit + 1L));
            ModelBusRevision revision = this.resource.getSelectedRevision();
            if (this.logMessages != null && this.logMessages.length > 1) {
                ModelBusLogEntry lm = this.logMessages[this.logMessages.length - 1];
                revision = ModelBusRevision.fromString((String)lm.revision);
            }
            msgsOp.setStartRevision(revision);
            this.fetchHistory(msgsOp);
        }
    }

    protected void setFilter() {
        HistoryFilterPanel panel = new HistoryFilterPanel(this.authorFilter.getAuthorNameToAccept(), this.commentFilter.getCommentToAccept(), this.changeFilter.getGangedPathToAccept(), ModelBusHistoryPage.getSelectedAuthors(this.logMessages));
        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getDisplay().getActiveShell(), panel);
        if (dialog.open() == 0) {
            this.authorFilter.setAuthorNameToAccept(panel.getAuthor());
            this.commentFilter.setCommentToAccept(panel.getComment());
            this.clearFilterItem.setEnabled(this.isFilterEnabled());
            this.history.refresh(3);
        }
    }

    protected void clearFilter() {
        this.authorFilter.setAuthorNameToAccept(null);
        this.commentFilter.setCommentToAccept(null);
        this.changeFilter.setGangedPathToAccept(null);
        this.clearFilterItem.setEnabled(false);
        this.history.refresh(3);
    }

    protected boolean isFilterEnabled() {
        return this.authorFilter.getAuthorNameToAccept() != null || this.commentFilter.getCommentToAccept() != null || this.changeFilter.getGangedPathToAccept() != null;
    }

    protected void refresh() {
        ModelBusRevision revision = this.history.getSelectedRevision();
        this.pagingEnabled = true;
        this.logMessages = null;
        this.pending = true;
        this.history.refresh(3);
        this.showNextPage(false);
        this.history.setSelectedRevision(revision.getRevision());
    }
}

