/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.ResourceSelectionComposite;
import org.modelbus.team.eclipse.ui.event.IResourceSelectionChangeListener;
import org.modelbus.team.eclipse.ui.event.ResourceSelectionChangedEvent;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;

public abstract class AbstractResourceSelectionPanel
extends AbstractDialogPanel {
    protected IResource[] resources;
    protected CheckboxTableViewer tableViewer;
    protected ResourceSelectionComposite selectionComposite;
    protected IResource[] userSelectedResources;

    public AbstractResourceSelectionPanel(IResource[] resources, IResource[] userSelectedResources, String[] buttonNames) {
        super(buttonNames);
        this.resources = resources;
        this.userSelectedResources = userSelectedResources;
    }

    public IResource[] getSelectedResources() {
        return this.selectionComposite != null ? this.selectionComposite.getSelectedResources() : null;
    }

    public IResource[] getNotSelectedResources() {
        return this.selectionComposite != null ? this.selectionComposite.getNotSelectedResources() : null;
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(600, -1);
    }

    @Override
    public void createControlsImpl(Composite parent) {
        this.selectionComposite = new ResourceSelectionComposite(parent, 0, this.resources, false, this.userSelectedResources);
        GridData data = new GridData(1808);
        data.heightHint = 210;
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

            @Override
            public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                AbstractResourceSelectionPanel.this.validateContent();
            }
        });
        this.attachTo((Control)this.selectionComposite, new AbstractVerifier(){

            @Override
            protected String getErrorMessage(Control input) {
                IResource[] selection = AbstractResourceSelectionPanel.this.getSelectedResources();
                if (selection == null || selection.length == 0) {
                    return ModelBusTeamUIPlugin.instance().getResource("ResourceSelectionComposite.Verifier.Error");
                }
                return null;
            }

            @Override
            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        this.addContextMenu();
    }

    @Override
    protected void saveChangesImpl() {
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected void addContextMenu() {
    }
}

