/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.ResourcesParentsProvider;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.AddToModelBusIgnoreOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.refactor.DeleteResourceOperation;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.resource.events.IResourceStatesListener;
import org.modelbus.team.eclipse.core.resource.events.ResourceStatesChangedEvent;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.dialog.DiscardConfirmationDialog;
import org.modelbus.team.eclipse.ui.panel.local.AbstractResourceSelectionPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class AddToModelBusPanel
extends AbstractResourceSelectionPanel {
    protected boolean actionTookEffect = false;
    protected IResourceStatesListener resourceStatesListener;

    public AddToModelBusPanel(IResource[] resources) {
        this(resources, null);
    }

    public AddToModelBusPanel(IResource[] resources, IResource[] userSelectedResources) {
        super(resources, userSelectedResources, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Description");
        this.defaultMessage = resources.length == 1 ? ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Message.Single") : ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Message.Multi", new String[]{String.valueOf(resources.length)});
    }

    @Override
    protected void addContextMenu() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)tableViewer.getSelection();
                final IResource[] selectedResources = tSelection.toList().toArray(new IResource[tSelection.size()]);
                Action tAction = null;
                if (selectedResources.length == 1) {
                    tAction = new Action(MessageFormat.format(ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Ignore.Single"), selectedResources[0].getName())){

                        public void run() {
                            CompositeOperation op = new CompositeOperation("AddToIgnore");
                            op.add((IActionOperation)new AddToModelBusIgnoreOperation(selectedResources, 0, null));
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(true);
                    String name = selectedResources[0].getName();
                    String[] parts = name.split("\\.");
                    if (parts.length != 0) {
                        tAction = new Action(MessageFormat.format(ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Ignore.Single"), "*." + parts[parts.length - 1])){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("AddToIgnore");
                                op.add((IActionOperation)new AddToModelBusIgnoreOperation(selectedResources, 1, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(true);
                    }
                } else {
                    tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.IgnoreByNames.Multiple")){

                        public void run() {
                            CompositeOperation op = new CompositeOperation("AddToIgnore");
                            op.add((IActionOperation)new AddToModelBusIgnoreOperation(selectedResources, 0, null));
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() > 0);
                    tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.IgnoreByExtension.Multiple")){

                        public void run() {
                            CompositeOperation op = new CompositeOperation("AddToIgnore");
                            op.add((IActionOperation)new AddToModelBusIgnoreOperation(selectedResources, 1, null));
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() > 0);
                }
                manager.add((IContributionItem)new Separator());
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("AddToModelBusPanel.Delete.Action.Lable")){

                    public void run() {
                        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), selectedResources.length == 1, 2);
                        if (dialog.open() == 0) {
                            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(selectedResources);
                            CompositeOperation op = new CompositeOperation(deleteOperation.getId());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(selectedResources);
                            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
                            op.add((IActionOperation)saveOp);
                            op.add((IActionOperation)deleteOperation);
                            op.add((IActionOperation)restoreOp);
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
                tAction.setEnabled(tSelection.size() > 0);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tableViewer.getTable().setMenu(menu);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                AddToModelBusPanel.this.updateResources();
            }
        };
        ModelBusRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    public boolean ifActionTookEffect() {
        return this.actionTookEffect;
    }

    public void updateResources() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        HashSet<IResource> toDeleteSet = new HashSet<IResource>();
        toDeleteSet.addAll(Arrays.asList(this.resources));
        HashSet<IResource> newResourcesSet = new HashSet<IResource>();
        newResourcesSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_UNVERSIONED, (int)0)));
        List<IResource> ignored = Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0));
        if (ignored.size() != 0) {
            this.actionTookEffect = true;
        }
        newResourcesSet.removeAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0)));
        int i = 0;
        while (i < this.resources.length) {
            if (!this.resources[i].exists()) {
                newResourcesSet.remove(this.resources[i]);
                this.actionTookEffect = true;
            }
            ++i;
        }
        final IResource[] newResources = newResourcesSet.toArray(new IResource[newResourcesSet.size()]);
        toDeleteSet.removeAll(newResourcesSet);
        final IResource[] toDeleteResources = toDeleteSet.toArray(new IResource[toDeleteSet.size()]);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AddToModelBusPanel.this.selectionComposite.setResources(newResources);
                if (!tableViewer.getTable().isDisposed()) {
                    tableViewer.remove((Object[])toDeleteResources);
                    tableViewer.refresh();
                    AddToModelBusPanel.this.selectionComposite.fireSelectionChanged();
                }
            }
        });
        this.resources = newResources;
    }

    @Override
    public void dispose() {
        super.dispose();
        ModelBusRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.addToVCDialogContext";
    }
}

