/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.CommentComposite;
import org.modelbus.team.eclipse.ui.composite.ResourceSelectionComposite;
import org.modelbus.team.eclipse.ui.event.IResourceSelectionChangeListener;
import org.modelbus.team.eclipse.ui.event.ResourceSelectionChangedEvent;
import org.modelbus.team.eclipse.ui.extension.factory.ICommentDialogPanel;
import org.modelbus.team.eclipse.ui.panel.common.CommentPanel;
import org.modelbus.team.eclipse.ui.panel.local.CommitPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;

public class CommitSetPanel
extends CommentPanel
implements ICommentDialogPanel {
    public static final int MSG_CREATE = 0;
    public static final int MSG_EDIT = 1;
    private final ActiveChangeSet set;
    protected ResourceSelectionComposite selectionComposite;
    private Text nameText;
    protected IResource[] resources;
    protected List<IResourceSelectionChangeListener> changeListenerList;

    public CommitSetPanel(ActiveChangeSet set, IResource[] resources, int type) {
        super(ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Title"));
        this.set = set;
        this.resources = resources;
        switch (type) {
            case 1: {
                this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Description.Edit");
                this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Message.Edit");
                break;
            }
            default: {
                this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Description.New");
                this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Message.New");
            }
        }
        if (resources == null) {
            resources = set.getResources();
        }
        this.changeListenerList = new ArrayList<IResourceSelectionChangeListener>();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        Composite composite = new Composite(parent, 0);
        GridLayout nameLayout = new GridLayout();
        nameLayout.marginHeight = 0;
        nameLayout.marginWidth = 0;
        nameLayout.numColumns = 2;
        composite.setLayout((Layout)nameLayout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Name"));
        label.setLayoutData((Object)new GridData(1));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        String initialText = this.set.getTitle();
        if (initialText == null) {
            initialText = "";
        }
        this.nameText.setText(initialText);
        this.nameText.selectAll();
        this.attachTo((Control)this.nameText, new NonEmptyFieldVerifier(ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Name.Verifier")));
        Group group = new Group(parent, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(ModelBusTeamUIPlugin.instance().getResource("CommitSetPanel.Comment"));
        CommitPanel.CollectPropertiesOperation op = new CommitPanel.CollectPropertiesOperation(this.resources);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
        this.bugtraqModel = op.getBugtraqModel();
        this.comment = new CommentComposite((Composite)group, this.set.getComment(), this, op.getLogTemplates(), null, op.getMinLogSize(), op.getMaxLogWidth());
        data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.commitSetDialogContext";
    }

    public IResource[] getSelectedResources() {
        return this.selectionComposite.getSelectedResources();
    }

    @Override
    public void addResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.add(listener);
    }

    @Override
    public void removeResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    public void fireResourcesSelectionChanged(ResourceSelectionChangedEvent event) {
        this.validateContent();
        IResourceSelectionChangeListener[] listeners = this.changeListenerList.toArray(new IResourceSelectionChangeListener[this.changeListenerList.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(525, -1);
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
        this.set.setTitle(this.nameText.getText());
        this.set.setComment(this.comment.getMessage());
    }
}

