/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.ModelBusContainerSelectionGroup;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.ResourceNameVerifier;

public class ContainerSelectionPanel
extends AbstractDialogPanel {
    protected ContainerSelectionGroup group;
    protected Button copyWithHistoryButton;
    protected IContainer initialRoot;
    protected Text nameBox;
    protected Button overrideResourceNameButton;
    protected IResource[] resources;
    protected IPath selectedPath;
    protected String defaultConflictMessage;
    protected int numConflicts;
    protected boolean copyWithHistorySelected;
    protected String name;
    protected boolean overrideResourceName;

    public ContainerSelectionPanel(IResource[] resources, HashSet conflicts) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.Description");
        this.selectedPath = null;
        this.initialRoot = resources[0].getParent();
        this.resources = resources;
        this.numConflicts = conflicts.size();
        this.defaultConflictMessage = "";
        this.getDefaultConflictMessage(conflicts);
        this.defaultConflictMessage = this.getDefaultConflictMessage(conflicts);
        this.defaultMessage = conflicts.size() == 0 ? ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.Message") : this.defaultConflictMessage;
    }

    public IPath getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isOverrideResourceName() {
        return this.overrideResourceName;
    }

    public String getOverridenName() {
        return this.name;
    }

    public boolean isCopyWithHistorySelected() {
        return this.copyWithHistorySelected;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridData data = null;
        this.group = new ModelBusContainerSelectionGroup(parent, new Listener(){

            public void handleEvent(Event event) {
                ContainerSelectionPanel.this.validateContent();
            }
        });
        this.group.setLayoutData((Object)new GridData(1808));
        this.attachTo((Control)this.group, new ContainerSelectionVerifier(this.defaultConflictMessage));
        this.overrideResourceNameButton = new Button(parent, 32);
        this.overrideResourceNameButton.setLayoutData((Object)new GridData());
        this.overrideResourceNameButton.setText(ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.NewName"));
        this.overrideResourceNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionPanel.this.nameBox.setEnabled(((Button)e.widget).getSelection());
                ContainerSelectionPanel.this.validateContent();
            }
        });
        this.overrideResourceNameButton.setSelection(false);
        this.nameBox = new Text(parent, 2052);
        data = new GridData(768);
        this.nameBox.setLayoutData((Object)data);
        this.nameBox.setText(this.resources[0].getName());
        this.nameBox.setEnabled(false);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.NewName.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ResourceNameVerifier(name, true));
        verifier.add(new AbstractFormattedVerifier(name){

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }

            @Override
            protected String getErrorMessageImpl(Control input) {
                IPath path = ContainerSelectionPanel.this.group.getContainerFullPath();
                if (path != null && ResourcesPlugin.getWorkspace().getRoot().findMember(path.append(this.getText(input))) != null) {
                    return ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.NewName.Verifier.Error");
                }
                return null;
            }
        });
        this.attachTo((Control)this.nameBox, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return ContainerSelectionPanel.this.overrideResourceNameButton.getSelection();
            }
        });
        this.copyWithHistoryButton = new Button(parent, 32);
        this.copyWithHistoryButton.setLayoutData((Object)new GridData());
        this.copyWithHistoryButton.setText(ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.KeepHistory"));
        this.copyWithHistoryButton.setSelection(true);
        this.copyWithHistoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionPanel.this.validateContent();
            }
        });
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.initialRoot != null) {
            this.group.setSelectedContainer(this.initialRoot);
        }
        if (this.numConflicts == 0) {
            this.manager.setMessage(0, null);
        } else {
            this.manager.setMessage(1, null);
        }
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.copyMoveToDialogContext";
    }

    @Override
    protected void saveChangesImpl() {
        this.selectedPath = this.group.getContainerFullPath();
        this.copyWithHistorySelected = this.copyWithHistoryButton.getSelection();
        this.name = this.nameBox.getText().trim();
        this.overrideResourceName = this.overrideResourceNameButton.getSelection();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected String getDefaultConflictMessage(HashSet conflicts) {
        if (conflicts.size() == 0) {
            return null;
        }
        int numberOfConflicts = 0;
        String message = "";
        for (String element : conflicts) {
            if (++numberOfConflicts >= 4) continue;
            message = String.valueOf(message) + (numberOfConflicts == 1 ? "'" + element + "'" : ", '" + element + "'");
        }
        if (numberOfConflicts >= 4) {
            message = String.valueOf(message) + "...";
        }
        return ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.ConflictMessage", new String[]{message});
    }

    public class ContainerSelectionVerifier
    extends ModelBusContainerSelectionGroup.ModelBusContainerSelectionVerifier {
        protected String SOME_RESOURCES_IN_CONFLICT_MESSAGE;
        protected String SOME_RESOURCE_IN_CONFLICT_MESSAGE;
        protected String ALL_RESOURCES_IN_CONFLICT_MESSAGE;
        protected String conflictedResources = "";
        protected String defaultConflictingResourcesNames;

        public ContainerSelectionVerifier(String conflictingResourcesNames) {
            this.defaultConflictingResourcesNames = conflictingResourcesNames;
            this.ALL_RESOURCES_IN_CONFLICT_MESSAGE = ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.Selection.Verifier.AllInConflict");
            this.SOME_RESOURCE_IN_CONFLICT_MESSAGE = ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.Selection.Verifier.SomeInConflict.Single");
            this.SOME_RESOURCES_IN_CONFLICT_MESSAGE = ModelBusTeamUIPlugin.instance().getResource("ContainerSelectionPanel.Selection.Verifier.SomeInConflict.Multi");
        }

        @Override
        protected String getErrorMessageImpl(Control input) {
            ModelBusContainerSelectionGroup control = (ModelBusContainerSelectionGroup)input;
            if (this.findConflicts(control) == ContainerSelectionPanel.this.resources.length) {
                return this.ALL_RESOURCES_IN_CONFLICT_MESSAGE;
            }
            return super.getErrorMessageImpl(input);
        }

        @Override
        protected String getWarningMessageImpl(Control input) {
            ModelBusContainerSelectionGroup control = (ModelBusContainerSelectionGroup)input;
            int numberconflicts = this.findConflicts(control);
            if (numberconflicts == 1) {
                return MessageFormat.format(this.SOME_RESOURCE_IN_CONFLICT_MESSAGE, this.conflictedResources);
            }
            if (numberconflicts > 1) {
                return MessageFormat.format(this.SOME_RESOURCES_IN_CONFLICT_MESSAGE, this.conflictedResources);
            }
            if (this.defaultConflictingResourcesNames != null) {
                return this.defaultConflictingResourcesNames;
            }
            return null;
        }

        protected int findConflicts(ModelBusContainerSelectionGroup control) {
            IPath containerPath = control.getContainerFullPath();
            if (containerPath == null) {
                return 0;
            }
            if (ContainerSelectionPanel.this.overrideResourceNameButton.getSelection()) {
                containerPath = containerPath.append(ContainerSelectionPanel.this.nameBox.getText().trim());
                if (ContainerSelectionPanel.this.resources.length == 1 && ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath) != null) {
                    this.conflictedResources = containerPath.lastSegment();
                    return 1;
                }
            }
            ArrayList<IResource> destResources = new ArrayList<IResource>();
            int numberOfConflictedResources = 0;
            int i = 0;
            while (i < ContainerSelectionPanel.this.resources.length) {
                IPath dest = containerPath.append(ContainerSelectionPanel.this.resources[i].getName());
                IResource destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(dest);
                if (destinationResource != null) {
                    ++numberOfConflictedResources;
                    destResources.add(destinationResource);
                }
                ++i;
            }
            this.conflictedResources = FileUtility.getNamesListAsString((Object[])destResources.toArray());
            return numberOfConflictedResources;
        }

        @Override
        protected boolean isNonModelBusCheckDisabled() {
            return ContainerSelectionPanel.this.copyWithHistoryButton.getSelection();
        }
    }
}

