/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusNotification;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.connector.ModelBusRevisionRange;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.JavaHLMergeOperation;
import org.modelbus.team.eclipse.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.DepthSelectionComposite;
import org.modelbus.team.eclipse.ui.composite.RepositoryResourceSelectionComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.AbstractAdvancedDialogPanel;
import org.modelbus.team.eclipse.ui.panel.IDialogManagerEx;
import org.modelbus.team.eclipse.ui.panel.reporting.PreviewPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;

public class MergePanel
extends AbstractAdvancedDialogPanel {
    public static final int MODE_1URL = 0;
    public static final int MODE_2URL = 1;
    public static final int MODE_REINTEGRATE = 2;
    protected static final String FIRST_URL_HISTORY = "Merge.FirstUrl";
    protected static final String SECOND_URL_HISTORY = "Merge.SecondUrl";
    protected IResource[] to;
    protected IRepositoryResource baseResource;
    protected ModelBusRevision currentRevision;
    protected DepthSelectionComposite depthSelector;
    protected DepthSelectionComposite depthSelectorSimple;
    protected IRepositoryResource firstSelectedResource;
    protected IRepositoryResource secondSelectedResource;
    protected ModelBusRevisionRange[] selectedRevisions;
    protected int mode;
    protected boolean ignoreAncestry;
    protected RepositoryResourceSelectionComposite simpleSelectionComposite;
    protected RepositoryResourceSelectionComposite firstSelectionComposite;
    protected RepositoryResourceSelectionComposite secondSelectionComposite;
    protected RepositoryResourceSelectionComposite reintegrateSelectionComposite;
    protected Button ignoreAncestryButton;
    protected Button ignoreAncestrySimpleButton;

    public MergePanel(IResource[] to, IRepositoryResource baseResource, ModelBusRevision currentRevision) {
        super(new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, new String[]{ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview")});
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("MergePanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("MergePanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("MergePanel.Message");
        this.to = to;
        this.firstSelectedResource = this.secondSelectedResource = baseResource;
        this.baseResource = this.secondSelectedResource;
        this.currentRevision = currentRevision;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(727, 245);
    }

    public ModelBusRevision getStartRevision() {
        return this.simpleSelectionComposite.getStartRevision();
    }

    public IRepositoryResource getSelectedResource() {
        IRepositoryResource retVal = ModelBusUtility.copyOf((IRepositoryResource)this.simpleSelectionComposite.getSelectedResource());
        retVal.setSelectedRevision(this.simpleSelectionComposite.getSecondSelectedRevision());
        return retVal;
    }

    public IRepositoryResource[] getSelection() {
        return this.getSelection(this.getSelectedResource());
    }

    public IRepositoryResource[] getFirstSelection() {
        return this.getSelection(this.firstSelectedResource);
    }

    public IRepositoryResource[] getSecondSelection() {
        return this.getSelection(this.secondSelectedResource);
    }

    public boolean getIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public ModelBusRevisionRange[] getSelectedRevisions() {
        return this.selectedRevisions;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        ((GridLayout)parent.getLayout()).verticalSpacing = 2;
        final TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ModelBusTeamUIPlugin.instance().getResource("MergePanel.1URL"));
        tabItem.setControl((Control)this.create1URLModeView((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ModelBusTeamUIPlugin.instance().getResource("MergePanel.2URL"));
        tabItem.setControl((Control)this.create2URLModeView((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Reintegrate"));
        tabItem.setControl((Control)this.createReintegrateModeView((Composite)tabFolder));
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergePanel.this.mode = tabFolder.getSelectionIndex();
                MergePanel.this.validateContent();
            }
        });
        this.mode = 0;
    }

    protected Composite create1URLModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        int mode = 2;
        this.simpleSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, new ValidationManagerProxy(){

            @Override
            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    @Override
                    protected boolean isVerificationEnabled(Control input) {
                        return (this).MergePanel.this.mode == 0;
                    }
                };
            }
        }, FIRST_URL_HISTORY, this.firstSelectedResource, true, ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Title"), ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Description"), mode, 2);
        data = new GridData(768);
        this.simpleSelectionComposite.setLayoutData(data);
        this.simpleSelectionComposite.setCurrentRevision(this.currentRevision);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        data = new GridData();
        this.ignoreAncestrySimpleButton = new Button(parent, 32);
        this.ignoreAncestrySimpleButton.setLayoutData((Object)data);
        this.ignoreAncestrySimpleButton.setText(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Button.IgnoreAncestry"));
        this.ignoreAncestrySimpleButton.setSelection(this.ignoreAncestry);
        this.depthSelectorSimple = new DepthSelectionComposite(parent, 0);
        this.depthSelectorSimple.setLayoutData(new GridData(768));
        this.depthSelectorSimple.addAndSelectWorkingCopyDepth();
        return parent;
    }

    protected Composite create2URLModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        final ValidationManagerProxy proxy2 = new ValidationManagerProxy(){

            @Override
            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    @Override
                    protected boolean isVerificationEnabled(Control input) {
                        return (this).MergePanel.this.mode == 1;
                    }
                };
            }
        };
        ValidationManagerProxy proxy = new ValidationManagerProxy(){

            @Override
            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    @Override
                    protected boolean isVerificationEnabled(Control input) {
                        return (this).MergePanel.this.mode == 1;
                    }

                    @Override
                    public boolean verify(Control input) {
                        for (Control cmp : proxy2.getControls()) {
                            proxy2.validateControl(cmp);
                        }
                        return super.verify(input);
                    }
                };
            }
        };
        this.firstSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, proxy, FIRST_URL_HISTORY, "MergePanel.SourceURL1", this.firstSelectedResource, true, ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Title"), ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Description"), 0, 2);
        data = new GridData(768);
        this.firstSelectionComposite.setLayoutData(data);
        this.firstSelectionComposite.setCurrentRevision(this.currentRevision);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        this.secondSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, proxy2, SECOND_URL_HISTORY, "MergePanel.SourceURL2", this.secondSelectedResource, true, ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Title"), ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Description"), 0, 2);
        data = new GridData(768);
        this.secondSelectionComposite.setLayoutData(data);
        this.secondSelectionComposite.setCurrentRevision(this.currentRevision);
        separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        data = new GridData();
        this.ignoreAncestryButton = new Button(parent, 32);
        this.ignoreAncestryButton.setLayoutData((Object)data);
        this.ignoreAncestryButton.setText(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Button.IgnoreAncestry"));
        this.ignoreAncestryButton.setSelection(this.ignoreAncestry);
        this.depthSelector = new DepthSelectionComposite(parent, 0);
        this.depthSelector.setLayoutData(new GridData(768));
        this.depthSelector.addAndSelectWorkingCopyDepth();
        return parent;
    }

    protected Composite createReintegrateModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        this.reintegrateSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, new ValidationManagerProxy(){

            @Override
            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(verifier){

                    @Override
                    protected boolean isVerificationEnabled(Control input) {
                        return (this).MergePanel.this.mode == 2;
                    }
                };
            }
        }, FIRST_URL_HISTORY, this.firstSelectedResource, true, ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Title"), ModelBusTeamUIPlugin.instance().getResource("MergePanel.Selection.Description"), 0, 2);
        data = new GridData(768);
        this.reintegrateSelectionComposite.setLayoutData(data);
        this.reintegrateSelectionComposite.setCurrentRevision(this.currentRevision);
        return parent;
    }

    public int getDepth() {
        return this.mode == 0 ? this.depthSelectorSimple.getDepth() : (this.mode == 1 ? this.depthSelector.getDepth() : -2);
    }

    @Override
    protected void showDetails() {
        this.saveChangesImpl();
        LocateResourceURLInHistoryOperation locateFirst = new LocateResourceURLInHistoryOperation(this.getFirstSelection());
        LocateResourceURLInHistoryOperation locateSecond = null;
        LocateResourceURLInHistoryOperation firstSet = locateFirst;
        LocateResourceURLInHistoryOperation secondSet = null;
        if (this.mode == 0) {
            firstSet = new IRepositoryResourceProvider.DefaultRepositoryResourceProvider(this.getFirstSelection());
        } else if (this.mode == 1) {
            secondSet = locateSecond = new LocateResourceURLInHistoryOperation(this.getSecondSelection());
        }
        JavaHLMergeOperation mergeOp = null;
        mergeOp = this.mode == 1 ? new JavaHLMergeOperation(this.to, (IRepositoryResourceProvider)firstSet, (IRepositoryResourceProvider)secondSet, true, this.getIgnoreAncestry(), this.getDepth()) : (this.mode == 0 ? new JavaHLMergeOperation(this.to, (IRepositoryResourceProvider)firstSet, this.getSelectedRevisions(), true, this.getIgnoreAncestry(), this.getDepth()) : new JavaHLMergeOperation(this.to, (IRepositoryResourceProvider)firstSet, true));
        final StringBuffer buf = new StringBuffer();
        buf.append(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Header.Text"));
        buf.append(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Header.Line"));
        mergeOp.setExternalMonitor(new IModelBusProgressMonitor(){

            public boolean isActivityCancelled() {
                return false;
            }

            public void progress(int current, int total, IModelBusProgressMonitor.ItemState state) {
                buf.append("<b>");
                switch (state.action) {
                    case 9: {
                        buf.append(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Added"));
                        break;
                    }
                    case 8: {
                        buf.append(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Deleted"));
                        break;
                    }
                    case 10: {
                        buf.append(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Modified"));
                        break;
                    }
                    default: {
                        if (ModelBusNotification.PerformedAction.isKnownAction((int)state.action)) {
                            buf.append(ModelBusNotification.PerformedAction.actionNames[state.action]);
                        } else {
                            buf.append("\t");
                        }
                        buf.append(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Default"));
                    }
                }
                buf.append(state.path);
                buf.append("\n");
            }
        });
        if (this.mode != 0) {
            CompositeOperation op = new CompositeOperation(mergeOp.getId());
            op.add((IActionOperation)locateFirst);
            if (this.mode == 1) {
                op.add((IActionOperation)locateSecond);
            }
            op.add((IActionOperation)mergeOp);
            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
        } else {
            UIMonitorUtility.doTaskNowDefault((IActionOperation)mergeOp, true);
        }
        if (mergeOp.getExecutionState() == 0) {
            Font font = new Font((Device)UIMonitorUtility.getDisplay(), "Courier New", 8, 0);
            new DefaultDialog(this.manager.getShell(), new PreviewPanel(ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Title"), ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Description"), ModelBusTeamUIPlugin.instance().getResource("MergePanel.Preview.Message"), buf.toString(), font)).open();
        }
    }

    @Override
    protected void saveChangesImpl() {
        if (this.mode == 0) {
            this.firstSelectedResource = this.simpleSelectionComposite.getSelectedResource();
            this.secondSelectedResource = this.simpleSelectionComposite.getSecondSelectedResource();
            this.selectedRevisions = this.simpleSelectionComposite.getSelectedRevisions();
            this.simpleSelectionComposite.saveHistory();
            this.ignoreAncestry = this.ignoreAncestrySimpleButton.getSelection();
        } else if (this.mode == 1) {
            this.firstSelectedResource = this.firstSelectionComposite.getSelectedResource();
            this.firstSelectionComposite.saveHistory();
            this.secondSelectedResource = this.secondSelectionComposite.getSelectedResource();
            this.secondSelectionComposite.saveHistory();
            this.ignoreAncestry = this.ignoreAncestryButton.getSelection();
        } else {
            this.firstSelectedResource = this.secondSelectedResource = this.reintegrateSelectionComposite.getSelectedResource();
            this.reintegrateSelectionComposite.saveHistory();
        }
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void setButtonsEnabled(boolean enabled) {
        ((IDialogManagerEx)this.manager).setExtendedButtonEnabled(0, enabled);
    }

    protected IRepositoryResource[] getSelection(IRepositoryResource base) {
        if (this.to.length == 1) {
            return new IRepositoryResource[]{base};
        }
        IRepositoryResource[] retVal = new IRepositoryResource[this.to.length];
        String baseUrl = base.getUrl();
        int i = 0;
        while (i < retVal.length) {
            String url = String.valueOf(baseUrl) + "/" + ModelBusRemoteStorage.instance().asRepositoryResource(this.to[i]).getName();
            retVal[i] = this.to[i].getType() == 1 ? base.asRepositoryFile(url, false) : base.asRepositoryContainer(url, false);
            ++i;
        }
        return retVal;
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.mergeDialogContext";
    }

    protected abstract class ValidationManagerProxy
    implements IValidationManager {
        protected Set<Control> controls = new HashSet<Control>();

        protected ValidationManagerProxy() {
        }

        @Override
        public void attachTo(Control cmp, AbstractVerifier verifier) {
            this.controls.add(cmp);
            MergePanel.this.attachTo(cmp, this.wrapVerifier(verifier));
        }

        @Override
        public void detachFrom(Control cmp) {
            this.controls.remove(cmp);
            MergePanel.this.detachFrom(cmp);
        }

        @Override
        public void detachAll() {
            MergePanel.this.detachAll();
        }

        @Override
        public boolean isFilledRight() {
            return MergePanel.this.isFilledRight();
        }

        @Override
        public void validateContent() {
            MergePanel.this.validateContent();
        }

        @Override
        public boolean validateControl(Control cmp) {
            return MergePanel.this.validateControl(cmp);
        }

        public Set<Control> getControls() {
            return this.controls;
        }

        protected abstract AbstractVerifier wrapVerifier(AbstractVerifier var1);
    }
}

