/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.utility.ArrayStructuredContentProvider;

public class ResourceListPanel
extends AbstractDialogPanel {
    protected IResource[] resources;
    protected TableViewer tableViewer;
    protected boolean showLocalNames;
    protected String helpId;
    protected Map<ImageDescriptor, Image> images;

    public ResourceListPanel(IResource[] resources, String dialogTitle, String dialogDescription, String defaultMessage, String[] buttons) {
        this(resources, dialogTitle, dialogDescription, defaultMessage, buttons, null);
    }

    public ResourceListPanel(IResource[] resources, String dialogTitle, String dialogDescription, String defaultMessage, String[] buttons, String helpId) {
        super(buttons);
        this.dialogTitle = dialogTitle;
        this.dialogDescription = dialogDescription;
        this.defaultMessage = defaultMessage;
        this.resources = resources;
        this.images = new HashMap<ImageDescriptor, Image>();
    }

    public boolean isShowLocalNames() {
        return this.showLocalNames;
    }

    public void setShowLocalNames(boolean showLocalNames) {
        this.showLocalNames = showLocalNames;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
        super.dispose();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        Table table = new Table(parent, 68356);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        GridData data = new GridData(1808);
        data.heightHint = 120;
        this.tableViewer.getTable().setLayoutData((Object)data);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(90, true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
                if (adapter == null) {
                    return null;
                }
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                if (descriptor == null) {
                    return null;
                }
                Image image = ResourceListPanel.this.images.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    ResourceListPanel.this.images.put(descriptor, image);
                }
                return image;
            }

            public String getColumnText(Object element, int columnIndex) {
                IResource resource = (IResource)element;
                if (ResourceListPanel.this.showLocalNames) {
                    return resource.getFullPath().toString().substring(1);
                }
                IRepositoryResource node = ModelBusRemoteStorage.instance().asRepositoryResource(resource);
                return node.getUrl();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        this.tableViewer.setInput((Object)this.resources);
    }

    @Override
    protected void saveChangesImpl() {
    }

    @Override
    protected void cancelChangesImpl() {
    }
}

