/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.ResourcesParentsProvider;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.CreatePatchOperation;
import org.modelbus.team.eclipse.core.operation.local.ExportOperation;
import org.modelbus.team.eclipse.core.operation.local.LockOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.UnlockOperation;
import org.modelbus.team.eclipse.core.operation.local.management.CleanupOperation;
import org.modelbus.team.eclipse.core.operation.local.refactor.DeleteResourceOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.resource.events.IResourceStatesListener;
import org.modelbus.team.eclipse.core.resource.events.ResourceStatesChangedEvent;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.local.BranchTagAction;
import org.modelbus.team.eclipse.ui.action.local.CompareWithWorkingCopyAction;
import org.modelbus.team.eclipse.ui.action.local.ReplaceWithLatestRevisionAction;
import org.modelbus.team.eclipse.ui.action.local.ReplaceWithRevisionAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.dialog.DiscardConfirmationDialog;
import org.modelbus.team.eclipse.ui.dialog.UnlockResourcesDialog;
import org.modelbus.team.eclipse.ui.operation.CompareResourcesOperation;
import org.modelbus.team.eclipse.ui.panel.local.AbstractResourceSelectionPanel;
import org.modelbus.team.eclipse.ui.panel.local.CommitPanel;
import org.modelbus.team.eclipse.ui.panel.local.LockPanel;
import org.modelbus.team.eclipse.ui.panel.remote.ComparePanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class RevertPanel
extends AbstractResourceSelectionPanel {
    protected boolean removeNonVersioned;
    protected boolean disableRemoveNonVersionedChange;
    protected IResourceStatesListener resourceStatesListener;

    public RevertPanel(IResource[] resources) {
        this(resources, null);
    }

    public RevertPanel(IResource[] resources, IResource[] userSelectedResources) {
        super(resources, userSelectedResources, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("RevertPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("RevertPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("RevertPanel.Message");
        IResource[] nonVersionedResources = FileUtility.getResourcesRecursive((IResource[])resources, (IStateFilter)IStateFilter.SF_NEW, (int)0);
        this.removeNonVersioned = this.disableRemoveNonVersionedChange = nonVersionedResources.length == resources.length;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        super.createControlsImpl(composite);
        this.createVerticalStrut(composite, 4);
        Label separator = new Label(composite, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        this.createVerticalStrut(composite, 7);
        final Button removeNonVersionedButton = new Button(composite, 32);
        data = new GridData();
        removeNonVersionedButton.setLayoutData((Object)data);
        removeNonVersionedButton.setText(ModelBusTeamUIPlugin.instance().getResource("RevertPanel.Button.RemoveNonVersioned"));
        removeNonVersionedButton.setSelection(this.removeNonVersioned);
        removeNonVersionedButton.setEnabled(!this.disableRemoveNonVersionedChange);
        removeNonVersionedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevertPanel.this.removeNonVersioned = removeNonVersionedButton.getSelection();
            }
        });
        this.addContextMenu();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                RevertPanel.this.updateResources(event);
            }
        };
        ModelBusRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        ModelBusRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    @Override
    protected void addContextMenu() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)tableViewer.getSelection();
                final IResource[] selectedResources = tSelection.toList().toArray(new IResource[tSelection.size()]);
                Action tAction = null;
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CreatePatchCommand.label")){

                    public void run() {
                        FileDialog dlg = new FileDialog(UIMonitorUtility.getShell(), 40960);
                        dlg.setText(ModelBusTeamUIPlugin.instance().getResource("SelectPatchFilePage.SavePatchAs"));
                        dlg.setFileName(String.valueOf(selectedResources[0].getName()) + ".patch");
                        dlg.setFilterExtensions(new String[]{"patch", "*.*"});
                        String file = dlg.open();
                        if (file != null) {
                            CreatePatchOperation mainOp = new CreatePatchOperation(new IResource[]{selectedResources[0]}, file, true, true, true, true);
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)mainOp, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED, (int)0));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("BranchAction.label")){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)2);
                        IActionOperation op = BranchTagAction.getBranchTagOperation(UIMonitorUtility.getShell(), 0, resources);
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0));
                tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/branch.gif"));
                manager.add((IContributionItem)new Separator());
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("LockAction.label")){

                    public void run() {
                        boolean containsFolder = false;
                        int i = 0;
                        while (i < selectedResources.length) {
                            if (selectedResources[i] instanceof IContainer) {
                                containsFolder = true;
                                break;
                            }
                            ++i;
                        }
                        CommitPanel.CollectPropertiesOperation cop = new CommitPanel.CollectPropertiesOperation(selectedResources);
                        ProgressMonitorUtility.doTaskExternal((IActionOperation)cop, null);
                        LockPanel commentPanel = new LockPanel(!containsFolder, cop.getMinLockSize());
                        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), commentPanel);
                        if (dialog.open() == 0) {
                            IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_READY_TO_LOCK, (int)(commentPanel.isRecursive() ? 2 : 1));
                            LockOperation mainOp = new LockOperation(resources, commentPanel.getMessage(), commentPanel.getForce());
                            CompositeOperation op = new CompositeOperation(mainOp.getId());
                            op.add((IActionOperation)mainOp);
                            op.add((IActionOperation)new RefreshResourcesOperation(resources));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/lock.gif"));
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_READY_TO_LOCK));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("UnlockAction.label")){

                    public void run() {
                        boolean recursive = false;
                        int i = 0;
                        while (i < selectedResources.length) {
                            if (selectedResources[i].getType() != 1) {
                                recursive = true;
                                break;
                            }
                            ++i;
                        }
                        UnlockResourcesDialog dialog = new UnlockResourcesDialog(UIMonitorUtility.getShell(), recursive);
                        if (dialog.open() == 0) {
                            IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_LOCKED, (int)(dialog.isRecursive() ? 2 : 1));
                            UnlockOperation mainOp = new UnlockOperation(resources);
                            CompositeOperation op = new CompositeOperation(mainOp.getId());
                            op.add((IActionOperation)mainOp);
                            op.add((IActionOperation)new RefreshResourcesOperation(resources));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/unlock.gif"));
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_LOCKED));
                manager.add((IContributionItem)new Separator());
                MenuManager subMenu = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("CommitPanel.CompareWith.Group"));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CompareWithWorkingCopyAction.label")){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? ModelBusUtility.getCopiedFrom((IResource)resource) : ModelBusRemoteStorage.instance().asRepositoryResource(resource);
                            remote.setSelectedRevision(ModelBusRevision.BASE);
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER, (int)0));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CompareWithLatestRevisionAction.label")){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? ModelBusUtility.getCopiedFrom((IResource)resource) : ModelBusRemoteStorage.instance().asRepositoryResource(resource);
                            remote.setSelectedRevision(ModelBusRevision.HEAD);
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CompareWithRevisionAction.label")){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? ModelBusUtility.getCopiedFrom((IResource)resource) : ModelBusRemoteStorage.instance().asRepositoryResource(resource);
                            ComparePanel panel = new ComparePanel(remote, local.getRevision());
                            DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                            if (dlg.open() == 0) {
                                remote = panel.getSelectedResource();
                                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                            }
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER));
                manager.add((IContributionItem)subMenu);
                subMenu = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("CommitPanel.ReplaceWith.Group"));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ReplaceWithLatestRevisionAction.label")){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0);
                        IActionOperation op = ReplaceWithLatestRevisionAction.getReplaceOperation(resources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ReplaceWithRevisionAction.label")){

                    public void run() {
                        IActionOperation op = ReplaceWithRevisionAction.getReplaceOperation(selectedResources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0));
                manager.add((IContributionItem)subMenu);
                manager.add((IContributionItem)new Separator());
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ExportCommand.label")){

                    public void run() {
                        DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
                        fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ExportAction.Select.Title"));
                        fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ExportAction.Select.Description"));
                        String path = fileDialog.open();
                        if (path != null) {
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ExportOperation(FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0), path, ModelBusRevision.WORKING));
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/export.gif"));
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0));
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CleanupCommand.label")){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED_FOLDERS, (int)0);
                        CleanupOperation mainOp = new CleanupOperation(resources);
                        CompositeOperation op = new CompositeOperation(mainOp.getId());
                        op.add((IActionOperation)mainOp);
                        op.add((IActionOperation)new RefreshResourcesOperation(resources));
                        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED_FOLDERS, (int)0));
                manager.add((IContributionItem)new Separator());
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CommitPanel.Delete.Action")){

                    public void run() {
                        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), selectedResources.length == 1, 2);
                        if (dialog.open() == 0) {
                            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(selectedResources);
                            CompositeOperation op = new CompositeOperation(deleteOperation.getId());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(selectedResources);
                            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
                            op.add((IActionOperation)saveOp);
                            op.add((IActionOperation)deleteOperation);
                            op.add((IActionOperation)restoreOp);
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_CHANGES));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
                tAction.setEnabled(tSelection.size() > 0 && !FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_DELETED, (int)0));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tableViewer.getTable().setMenu(menu);
    }

    protected void updateResources(ResourceStatesChangedEvent event) {
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(this.resources));
        HashSet<IResource> toDeleteSet = new HashSet<IResource>();
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTMODIFIED, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTEXISTS, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0)));
        allResources.removeAll(toDeleteSet);
        final IResource[] newResources = allResources.toArray(new IResource[allResources.size()]);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!RevertPanel.this.selectionComposite.isDisposed()) {
                    RevertPanel.this.selectionComposite.setResources(newResources);
                    RevertPanel.this.selectionComposite.fireSelectionChanged();
                }
            }
        });
        this.resources = newResources;
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.revertDialogContext";
    }

    public boolean getRemoveNonVersioned() {
        return this.removeNonVersioned;
    }

    protected void createVerticalStrut(Composite parent, int height) {
        Label strut = new Label(parent, 0);
        GridData data = new GridData();
        data.heightHint = height;
        strut.setLayoutData((Object)data);
    }
}

