/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.local;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.ResourceNameVerifier;

public class SavePatchInWorkspacePanel
extends AbstractDialogPanel {
    protected TreeViewer treeViewer;
    protected Text workspaceFilenameField;
    protected String proposedName;
    protected IFile file;

    public SavePatchInWorkspacePanel(String proposedName) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.Message");
        this.proposedName = proposedName;
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.savePatchInWorkspaceContext";
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(640, 300);
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        this.treeViewer = new TreeViewer(parent, 2048);
        data = new GridData(1808);
        this.treeViewer.getTree().setLayoutData((Object)data);
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(false);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SavePatchInWorkspacePanel.this.validateContent();
            }
        });
        AbstractFormattedVerifier verifier = new AbstractFormattedVerifier(ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.WorkspaceTree")){

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }

            @Override
            protected String getErrorMessageImpl(Control input) {
                IStructuredSelection selection = (IStructuredSelection)SavePatchInWorkspacePanel.this.treeViewer.getSelection();
                return selection != null && !selection.isEmpty() ? null : ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.WorkspaceTree.Verifier.Error");
            }
        };
        this.attachTo((Control)this.treeViewer.getTree(), verifier);
        Composite wsComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        wsComposite.setLayoutData((Object)data);
        Label description = new Label(wsComposite, 0);
        data = new GridData();
        description.setLayoutData((Object)data);
        description.setText(ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.FileName"));
        this.workspaceFilenameField = new Text(wsComposite, 2052);
        data = new GridData(768);
        this.workspaceFilenameField.setLayoutData((Object)data);
        CompositeVerifier cVerifier = new CompositeVerifier();
        String name = ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.FileName.Verifier");
        cVerifier.add(new NonEmptyFieldVerifier(name));
        cVerifier.add(new ResourceNameVerifier(name, false));
        cVerifier.add(new AbstractFormattedVerifier(name){

            @Override
            protected String getErrorMessageImpl(Control input) {
                return null;
            }

            @Override
            protected String getWarningMessageImpl(Control input) {
                IFile file = SavePatchInWorkspacePanel.this.makeFile();
                if (file != null && file.isAccessible()) {
                    return ModelBusTeamUIPlugin.instance().getResource("SavePatchInWorkspace.FileName.Verifier.Warning", new String[]{"$FIELD_NAME$"});
                }
                return null;
            }
        });
        this.attachTo((Control)this.workspaceFilenameField, cVerifier);
        this.workspaceFilenameField.setText(this.proposedName);
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        this.file = this.makeFile();
    }

    protected IFile makeFile() {
        String fileName = this.workspaceFilenameField.getText();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            IContainer treeNode = (IContainer)selection.getFirstElement();
            return treeNode.getProject().getFile(treeNode.getFullPath().append(fileName).removeFirstSegments(1));
        }
        return null;
    }
}

