/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.remote;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.CommentComposite;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.verifier.AbsolutePathVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.ResourceNameVerifier;

public abstract class AbstractGetResourceNamePanel
extends AbstractDialogPanel {
    protected String resourceName;
    protected String disallowedName;
    protected Text text;
    protected CommentComposite comment;
    protected boolean allowMultipart;

    public AbstractGetResourceNamePanel(String title, boolean allowMultipart) {
        this.dialogTitle = title;
        this.allowMultipart = allowMultipart;
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource(allowMultipart ? "AbstractGetResourceNamePanel.Message.MultiPart" : "AbstractGetResourceNamePanel.Message.Simple");
        this.resourceName = "";
    }

    public String getResourceName() {
        return this.resourceName.trim();
    }

    public String getMessage() {
        return this.comment.getMessage();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        Composite nameComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nameComposite.setLayout((Layout)layout);
        data = new GridData(768);
        nameComposite.setLayoutData((Object)data);
        Label nameLabel = new Label(nameComposite, 0);
        nameLabel.setText(ModelBusTeamUIPlugin.instance().getResource("AbstractGetResourceNamePanel.Name"));
        this.text = new Text(nameComposite, 2052);
        data = new GridData(768);
        this.text.setLayoutData((Object)data);
        this.text.setEditable(true);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(this.createNonEmptyNameFieldVerifier());
        String name = ModelBusTeamUIPlugin.instance().getResource("AbstractGetResourceNamePanel.Name.Verifier");
        verifier.add(new ResourceNameVerifier(name, this.allowMultipart));
        verifier.add(new AbsolutePathVerifier(name));
        verifier.add(new AbstractFormattedVerifier(name){
            private String msg;
            {
                this.msg = ModelBusTeamUIPlugin.instance().getResource("AbstractGetResourceNamePanel.Name.Verifier.Error");
            }

            @Override
            protected String getErrorMessageImpl(Control input) {
                String text = this.getText(input);
                if (AbstractGetResourceNamePanel.this.disallowedName != null && AbstractGetResourceNamePanel.this.disallowedName.equals(text)) {
                    return MessageFormat.format(this.msg, "$FIELD_NAME$", text);
                }
                return null;
            }

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
        this.attachTo((Control)this.text, verifier);
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(ModelBusTeamUIPlugin.instance().getResource("AbstractGetResourceNamePanel.Comment"));
        this.comment = new CommentComposite((Composite)group, this);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(525, -1);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
    }

    @Override
    protected void saveChangesImpl() {
        this.resourceName = this.text.getText();
        this.comment.saveChanges();
    }

    @Override
    protected void cancelChangesImpl() {
        this.comment.cancelChanges();
    }

    protected AbstractVerifier createNonEmptyNameFieldVerifier() {
        return new NonEmptyFieldVerifier(ModelBusTeamUIPlugin.instance().getResource("AbstractGetResourceNamePanel.Name.Verifier"));
    }
}

