/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.remote;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.DepthSelectionComposite;
import org.modelbus.team.eclipse.ui.composite.RevisionComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.verifier.ExistingResourceVerifier;

public class ExportPanel
extends AbstractDialogPanel {
    protected Text locationField;
    protected String location;
    protected RevisionComposite revisionComposite;
    protected IRepositoryResource selectedResource;
    protected DepthSelectionComposite depthSelector;

    public ExportPanel(IRepositoryResource baseResource) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("ExportPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("ExportPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("ExportPanel.Message");
        this.selectedResource = baseResource;
    }

    public ModelBusRevision getSelectedRevision() {
        return this.revisionComposite != null ? this.revisionComposite.getSelectedRevision() : ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
    }

    @Override
    protected void saveChangesImpl() {
        this.location = this.locationField.getText();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    public int getDepth() {
        if (this.depthSelector == null) {
            return 3;
        }
        return this.depthSelector.getDepth();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite folderComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        folderComposite.setLayout((Layout)layout);
        data = new GridData(768);
        folderComposite.setLayoutData((Object)data);
        Label label = new Label(folderComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.Folder"));
        this.locationField = new Text(folderComposite, 2052);
        data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        this.attachTo((Control)this.locationField, new ExistingResourceVerifier(label.getText(), false));
        Button browseButton = new Button(folderComposite, 8);
        browseButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browseButton);
        browseButton.setLayoutData((Object)data);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(ExportPanel.this.manager.getShell());
                fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder"));
                fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder.Msg"));
                String path = fileDialog.open();
                if (path != null) {
                    ExportPanel.this.locationField.setText(path);
                }
            }
        });
        if (this.selectedResource != null) {
            this.revisionComposite = new RevisionComposite(parent, this, false, null, ModelBusRevision.HEAD, false);
            data = new GridData(768);
            this.revisionComposite.setLayoutData(data);
            this.revisionComposite.setSelectedResource(this.selectedResource);
        }
        if (this.selectedResource instanceof IRepositoryContainer || this.selectedResource == null) {
            Label separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(768));
            separator.setVisible(false);
            this.depthSelector = new DepthSelectionComposite(parent, 0);
            data = new GridData(768);
            this.depthSelector.setLayoutData(data);
        }
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.remote_exportDialogContext";
    }

    public String getLocation() {
        return this.location;
    }
}

