/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.remote;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.CommentComposite;
import org.modelbus.team.eclipse.ui.composite.DepthSelectionComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.verifier.ExistingResourceVerifier;

public class ImportPanel
extends AbstractDialogPanel {
    protected Text locationField;
    protected String location;
    protected Button recursiveButton;
    protected DepthSelectionComposite depthSelector;
    protected CommentComposite comment;

    public ImportPanel(String importToUrl) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("ImportPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("ImportPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("ImportPanel.Message", new String[]{importToUrl});
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite folderSelectionComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        folderSelectionComposite.setLayout((Layout)layout);
        data = new GridData(768);
        folderSelectionComposite.setLayoutData((Object)data);
        Label folder = new Label(folderSelectionComposite, 0);
        folder.setText(ModelBusTeamUIPlugin.instance().getResource("ImportPanel.Folder"));
        this.locationField = new Text(folderSelectionComposite, 2052);
        data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        this.attachTo((Control)this.locationField, new ExistingResourceVerifier(folder.getText(), false));
        Button browseButton = new Button(folderSelectionComposite, 8);
        browseButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browseButton);
        browseButton.setLayoutData((Object)data);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(ImportPanel.this.manager.getShell());
                fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ImportPanel.ImportFolder"));
                fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ImportPanel.ImportFolder.Msg"));
                String path = fileDialog.open();
                if (path != null) {
                    ImportPanel.this.locationField.setText(path);
                }
            }
        });
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(ModelBusTeamUIPlugin.instance().getResource("ImportPanel.Comment"));
        this.comment = new CommentComposite((Composite)group, this);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        this.depthSelector = new DepthSelectionComposite(parent, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.depthSelector.setLayoutData(data);
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.remote_importDialogContext";
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(525, -1);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
    }

    @Override
    protected void saveChangesImpl() {
        this.location = this.locationField.getText();
        this.comment.saveChanges();
    }

    @Override
    protected void cancelChangesImpl() {
        this.comment.cancelChanges();
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.comment.getMessage();
    }

    public int getDepth() {
        return this.depthSelector.getDepth();
    }
}

