/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.reporting;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.modelbus.team.eclipse.core.utility.PatternProvider;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;

public class PreviewPanel
extends AbstractDialogPanel {
    protected String report;
    protected Font font;

    public PreviewPanel(String title, String description, String message, String report) {
        this(title, description, message, report, null);
    }

    public PreviewPanel(String title, String description, String message, String report, Font font) {
        super(new String[]{IDialogConstants.OK_LABEL});
        this.dialogTitle = title;
        this.dialogDescription = description;
        this.defaultMessage = message;
        this.report = report;
        this.font = font;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        Point prefferedSize = this.getPrefferedSize();
        data.widthHint = prefferedSize.x;
        data.heightHint = prefferedSize.y;
        composite.setLayoutData((Object)data);
        this.report = PatternProvider.replaceAll((String)this.report, (String)"<br>", (String)"\n");
        this.report = PatternProvider.replaceAll((String)this.report, (String)"&lt;", (String)"<");
        this.report = PatternProvider.replaceAll((String)this.report, (String)"&gt;", (String)">");
        StyledText styledText = new StyledText(composite, 2882);
        if (this.font != null) {
            styledText.setFont(this.font);
        }
        List<Object> styledRanges = new ArrayList();
        styledRanges = this.getStyleRanges();
        styledText.setText(this.report);
        styledText.setStyleRanges(styledRanges.toArray(new StyleRange[styledRanges.size()]));
        styledText.setEditable(false);
        styledText.setLayoutData((Object)data);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.font != null) {
            this.font.dispose();
        }
    }

    @Override
    protected void saveChangesImpl() {
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected List<StyleRange> getStyleRanges() {
        ArrayList<StyleRange> styledRanges = new ArrayList<StyleRange>();
        Stack<StyleRange> boldEntries = new Stack<StyleRange>();
        Stack<StyleRange> italicEntries = new Stack<StyleRange>();
        int i = 0;
        while (i < this.report.length()) {
            if (this.report.charAt(i) == '<' && i < this.report.length() - 2) {
                StyleRange range;
                if (this.report.charAt(i + 2) == '>') {
                    range = new StyleRange();
                    range.start = i;
                    if (this.report.charAt(i + 1) == 'b') {
                        range.fontStyle = 1;
                        boldEntries.push(range);
                        this.report = String.valueOf(this.report.substring(0, i)) + this.report.substring(i + 3);
                    } else if (this.report.charAt(i + 1) == 'i') {
                        range.fontStyle = 2;
                        italicEntries.push(range);
                        this.report = String.valueOf(this.report.substring(0, i)) + this.report.substring(i + 3);
                    }
                } else if (this.report.charAt(i + 1) == '/' && i < this.report.length() - 3 && this.report.charAt(i + 3) == '>') {
                    if (this.report.charAt(i + 2) == 'b') {
                        if (boldEntries.size() > 0) {
                            range = (StyleRange)boldEntries.pop();
                            range.length = i - range.start;
                            styledRanges.add(range);
                            this.report = String.valueOf(this.report.substring(0, i)) + this.report.substring(i + 4);
                        }
                    } else if (this.report.charAt(i + 2) == 'i' && italicEntries.size() > 0) {
                        range = (StyleRange)italicEntries.pop();
                        range.length = i - range.start;
                        styledRanges.add(range);
                        this.report = String.valueOf(this.report.substring(0, i)) + this.report.substring(i + 4);
                    }
                }
            }
            ++i;
        }
        return styledRanges;
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(640, 300);
    }
}

