/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.view;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.utility.UserInputHistory;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;

public class HistoryFilterPanel
extends AbstractDialogPanel {
    protected static final String FILTER_AUTHOR_HISTORY_NAME = "filterAuthor";
    protected static final String FILTER_COMMENT_HISTORY_NAME = "filterComment";
    protected static final String FILTER_PATH_HISTORY_NAME = "filterPath";
    protected String filter;
    protected Button authorButton;
    protected Button commentButton;
    protected Button pathButton;
    protected Combo authorsCombo;
    protected Combo commentsCombo;
    protected Combo pathCombo;
    protected String authorInput;
    protected String commentInput;
    protected String pathInput;
    protected String[] selectedAuthors;
    protected UserInputHistory authorsHistory;
    protected UserInputHistory commentsHistory;
    protected UserInputHistory pathHistory;

    public HistoryFilterPanel(String authorInput, String commentInput, String pathInput, String[] selectedAuthors) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Message");
        this.selectedAuthors = selectedAuthors;
        this.authorInput = authorInput;
        this.commentInput = commentInput;
        this.pathInput = pathInput;
    }

    public String getAuthor() {
        return this.authorInput;
    }

    public String getComment() {
        return this.commentInput;
    }

    public String getChangedPath() {
        return this.pathInput;
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(470, 100);
    }

    @Override
    public void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.authorButton = new Button(composite, 32);
        this.authorButton.setText(ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Author"));
        data = new GridData();
        this.authorButton.setLayoutData((Object)data);
        boolean enabledAuthor = this.authorInput != null;
        this.authorButton.setSelection(enabledAuthor);
        this.authorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.authorsCombo.setEnabled(((Button)e.widget).getSelection());
            }
        });
        this.authorsHistory = new UserInputHistory(FILTER_AUTHOR_HISTORY_NAME);
        this.authorsCombo = new Combo(composite, 0);
        data = new GridData(768);
        this.authorsCombo.setLayoutData((Object)data);
        this.authorsCombo.setEnabled(enabledAuthor);
        this.authorsCombo.setVisibleItemCount(this.authorsHistory.getDepth());
        this.authorsCombo.setItems(this.mergeAuthorsList());
        this.authorsCombo.setText(this.authorInput == null ? "" : this.authorInput);
        this.commentButton = new Button(composite, 32);
        this.commentButton.setText(ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Comment"));
        data = new GridData();
        this.commentButton.setLayoutData((Object)data);
        boolean enabledComment = this.commentInput != null;
        this.commentButton.setSelection(enabledComment);
        this.commentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.commentsCombo.setEnabled(((Button)e.widget).getSelection());
            }
        });
        this.commentsHistory = new UserInputHistory(FILTER_COMMENT_HISTORY_NAME);
        this.commentsCombo = new Combo(composite, 0);
        data = new GridData(768);
        this.commentsCombo.setLayoutData((Object)data);
        this.commentsCombo.setEnabled(enabledComment);
        this.commentsCombo.setVisibleItemCount(this.commentsHistory.getDepth());
        this.commentsCombo.setItems(this.commentsHistory.getHistory());
        this.commentsCombo.setText(this.commentInput == null ? "" : this.commentInput);
        this.pathButton = new Button(composite, 32);
        this.pathButton.setText(ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Path"));
        data = new GridData();
        this.pathButton.setLayoutData((Object)data);
        boolean enabledPath = this.pathInput != null;
        this.pathButton.setSelection(enabledPath);
        this.pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.pathCombo.setEnabled(((Button)e.widget).getSelection());
                HistoryFilterPanel.this.validateContent();
            }
        });
        this.pathHistory = new UserInputHistory(FILTER_PATH_HISTORY_NAME);
        this.pathCombo = new Combo(composite, 0);
        data = new GridData(768);
        this.pathCombo.setLayoutData((Object)data);
        this.pathCombo.setEnabled(enabledPath);
        this.pathCombo.setVisibleItemCount(this.pathHistory.getDepth());
        this.pathCombo.setItems(this.pathHistory.getHistory());
        this.pathCombo.setText(this.pathInput == null ? "" : this.pathInput);
        this.attachTo((Control)this.pathCombo, new NonEmptyFieldVerifier(ModelBusTeamUIPlugin.instance().getResource("HistoryFilterPanel.Path")){

            @Override
            protected String getErrorMessageImpl(Control input) {
                if (HistoryFilterPanel.this.pathCombo.isEnabled()) {
                    return super.getErrorMessageImpl(input);
                }
                return null;
            }
        });
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.historyDialogContext";
    }

    @Override
    protected void saveChangesImpl() {
        if (this.authorButton.getSelection()) {
            this.authorInput = this.authorsCombo.getText();
            this.authorsHistory.addLine(this.authorInput);
        } else {
            this.authorInput = null;
        }
        if (this.commentButton.getSelection()) {
            this.commentInput = this.commentsCombo.getText();
            this.commentsHistory.addLine(this.commentInput);
        } else {
            this.commentInput = null;
        }
        if (this.pathButton.getSelection()) {
            this.pathInput = this.pathCombo.getText();
            this.pathHistory.addLine(this.pathInput);
        } else {
            this.pathInput = null;
        }
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected String[] mergeAuthorsList() {
        HashSet<String> merged = new HashSet<String>(Arrays.asList(this.selectedAuthors));
        merged.addAll(Arrays.asList(this.authorsHistory.getHistory()));
        Object[] retVal = merged.toArray(new String[merged.size()]);
        Arrays.sort(retVal);
        return retVal;
    }
}

