/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.RevisionComposite;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class HistoryRangePanel
extends AbstractDialogPanel {
    protected IRepositoryResource resource;
    protected IRepositoryResource initStartResource;
    protected IRepositoryResource initStopResource;
    protected RevisionComposite startComposite;
    protected RevisionComposite stopComposite;
    protected boolean reversed;

    public HistoryRangePanel(IRepositoryResource resource, ModelBusRevision initStartRevision, ModelBusRevision initStopRevision) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("HistoryRangePanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("HistoryRangePanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("HistoryRangePanel.Message");
        this.resource = resource;
        this.initStartResource = ModelBusUtility.copyOf((IRepositoryResource)resource);
        this.initStartResource.setSelectedRevision(initStartRevision);
        this.initStopResource = ModelBusUtility.copyOf((IRepositoryResource)resource);
        this.initStopResource.setSelectedRevision(initStopRevision);
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(715, -1);
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.historyRangeDialogContext";
    }

    public ModelBusRevision getStartRevision() {
        return (this.reversed ? this.stopComposite : this.startComposite).getSelectedRevision();
    }

    public ModelBusRevision getStopRevision() {
        return (this.reversed ? this.startComposite : this.stopComposite).getSelectedRevision();
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite cmp = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        cmp.setLayout((Layout)layout);
        data = new GridData(1808);
        cmp.setLayoutData((Object)data);
        String defaultRevision = ModelBusTeamUIPlugin.instance().getResource("HistoryRangePanel.Default");
        this.startComposite = new RevisionComposite(cmp, this, true, new String[]{ModelBusTeamUIPlugin.instance().getResource("HistoryRangePanel.StartRevision"), defaultRevision}, null, false);
        this.startComposite.setBaseResource(this.resource);
        this.startComposite.setSelectedResource(this.initStartResource);
        this.stopComposite = new RevisionComposite(cmp, this, true, new String[]{ModelBusTeamUIPlugin.instance().getResource("HistoryRangePanel.StopRevision"), defaultRevision}, null, false);
        this.stopComposite.setBaseResource(this.resource);
        this.stopComposite.setSelectedResource(this.initStopResource);
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        if (this.getStartRevision() == null || this.getStopRevision() == null) {
            return;
        }
        this.initStartResource.setSelectedRevision(this.getStartRevision());
        this.initStopResource.setSelectedRevision(this.getStopRevision());
        UIMonitorUtility.doTaskNowDefault((IActionOperation)new AbstractActionOperation("Operation.CheckRevisions"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
                HistoryRangePanel.this.reversed = ModelBusUtility.compareRevisions((ModelBusRevision)HistoryRangePanel.this.initStartResource.getSelectedRevision(), (ModelBusRevision)HistoryRangePanel.this.initStopResource.getSelectedRevision(), (ModelBusEntryRevisionReference)ModelBusUtility.getEntryRevisionReference((IRepositoryResource)HistoryRangePanel.this.initStartResource), (ModelBusEntryRevisionReference)ModelBusUtility.getEntryRevisionReference((IRepositoryResource)HistoryRangePanel.this.initStopResource), (IModelBusConnector)proxy) == -1;
            }
        }, false);
    }
}

