/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.SpellcheckedTextProvider;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.common.EditCommentTemplatePanel;
import org.modelbus.team.eclipse.ui.preferences.AbstractModelBusTeamPreferencesPage;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.IntegerFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;

public class ModelBusTeamCommentTemplatesPreferencesPage
extends AbstractModelBusTeamPreferencesPage
implements ISelectionChangedListener {
    protected StyledText previewText;
    protected ListViewer listViewer;
    protected Button newButton;
    protected Button editButton;
    protected Button removeButton;
    protected Button useLogTemplatesButton;
    protected Button useTemplatesButton;
    protected int savedCommentsCount;
    protected Text savedCommentsCountField;
    protected boolean logTemplatesEnabled;
    protected boolean userTemplatesEnabled;

    @Override
    protected void saveValues(IPreferenceStore store) {
        ModelBusTeamPreferences.setCommentTemplatesInt(store, "savedCommentsCount", this.savedCommentsCount);
        ModelBusTeamPreferences.setCommentTemplatesBoolean(store, "comment.logTemplates.enabled", this.logTemplatesEnabled);
        ModelBusTeamPreferences.setCommentTemplatesBoolean(store, "comment.templates.enabled", this.userTemplatesEnabled);
        int numTemplates = this.listViewer.getList().getItemCount();
        String[] templates = new String[numTemplates];
        int i = 0;
        while (i < numTemplates) {
            templates[i] = (String)this.listViewer.getElementAt(i);
            ++i;
        }
        ModelBusTeamPreferences.setCommentTemplatesString(store, "comment.templates", FileUtility.encodeArrayToString((String[])templates));
    }

    @Override
    protected void loadDefaultValues(IPreferenceStore store) {
        this.savedCommentsCount = 10;
    }

    @Override
    protected void loadValues(IPreferenceStore store) {
        this.savedCommentsCount = ModelBusTeamPreferences.getCommentTemplatesInt(store, "savedCommentsCount");
        this.logTemplatesEnabled = ModelBusTeamPreferences.getCommentTemplatesBoolean(store, "comment.logTemplates.enabled");
        this.userTemplatesEnabled = ModelBusTeamPreferences.getCommentTemplatesBoolean(store, "comment.templates.enabled");
    }

    @Override
    protected void initializeControls() {
        this.savedCommentsCountField.setText(String.valueOf(this.savedCommentsCount));
        this.useLogTemplatesButton.setSelection(this.logTemplatesEnabled);
        this.useTemplatesButton.setSelection(this.userTemplatesEnabled);
        this.listViewer.getControl().setEnabled(this.userTemplatesEnabled);
        this.newButton.setEnabled(this.userTemplatesEnabled);
        this.previewText.setEnabled(this.userTemplatesEnabled);
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.editButton.setEnabled(this.userTemplatesEnabled && selection.size() == 1);
        this.removeButton.setEnabled(this.userTemplatesEnabled && selection.size() > 0);
        this.previewText.setText(selection.size() == 1 ? (String)selection.getFirstElement() : "");
    }

    @Override
    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite checkBoxComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        checkBoxComposite.setLayout((Layout)layout);
        checkBoxComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(checkBoxComposite, 0);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        String labelText = ModelBusTeamUIPlugin.instance().getResource("CommentTemplatesPreferencePage.historySavedCommentsCount");
        label.setText(labelText);
        this.savedCommentsCountField = new Text(checkBoxComposite, 2052);
        data = new GridData(768);
        this.savedCommentsCountField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.savedCommentsCountField, verifier);
        this.savedCommentsCountField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ModelBusTeamCommentTemplatesPreferencesPage.this.savedCommentsCount = Integer.parseInt(ModelBusTeamCommentTemplatesPreferencesPage.this.savedCommentsCountField.getText());
                }
                catch (Exception exception) {}
            }
        });
        this.useLogTemplatesButton = new Button(checkBoxComposite, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.useLogTemplatesButton.setLayoutData((Object)data);
        this.useLogTemplatesButton.setText(ModelBusTeamUIPlugin.instance().getResource("CommentTemplatesPreferencePage.LogTemplates"));
        this.useLogTemplatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamCommentTemplatesPreferencesPage.this.logTemplatesEnabled = ((Button)e.widget).getSelection();
            }
        });
        this.useTemplatesButton = new Button(checkBoxComposite, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.useTemplatesButton.setLayoutData((Object)data);
        this.useTemplatesButton.setText(ModelBusTeamUIPlugin.instance().getResource("CommentTemplatesPreferencePage.UserTemplates"));
        this.useTemplatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamCommentTemplatesPreferencesPage.this.selectionChanged(null);
            }
        });
        Label separator = new Label(checkBoxComposite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        Label templatesLabel = new Label(composite, 0);
        templatesLabel.setText(ModelBusTeamUIPlugin.instance().getResource("CommentTemplatesPreferencePage.EditHint"));
        this.createTemplatesList(composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.modelbus.team.eclipse.help.commentTemplatesPreferencesContext");
        return composite;
    }

    protected Composite createTemplatesList(Composite parent) {
        Composite listAndButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        listAndButtons.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 430;
        listAndButtons.setLayoutData((Object)data);
        this.listViewer = new ListViewer(listAndButtons);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String template = (String)element;
                return FileUtility.flattenText((String)template);
            }
        });
        this.listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.listViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String template1 = FileUtility.flattenText((String)((String)e1));
                String template2 = FileUtility.flattenText((String)((String)e2));
                return template1.compareToIgnoreCase(template2);
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelBusTeamCommentTemplatesPreferencesPage.this.editTemplate();
            }
        });
        List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        String[] templates = FileUtility.decodeStringToArray((String)ModelBusTeamPreferences.getCommentTemplatesString(store, "comment.templates"));
        int i = 0;
        while (i < templates.length) {
            this.listViewer.add((Object)templates[i]);
            ++i;
        }
        this.createButtons(listAndButtons);
        Label previewLabel = new Label(listAndButtons, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        previewLabel.setLayoutData((Object)data);
        previewLabel.setText(ModelBusTeamUIPlugin.instance().getResource("CommentTemplatesPreferencePage.ViewHint"));
        data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        this.previewText = SpellcheckedTextProvider.getTextWidget(listAndButtons, data, 578);
        this.previewText.setEditable(false);
        return listAndButtons;
    }

    protected void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.New"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(this.newButton);
        this.newButton.setLayoutData((Object)data);
        this.newButton.setEnabled(true);
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ModelBusTeamCommentTemplatesPreferencesPage.this.newTemplate();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Edit"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(this.editButton);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ModelBusTeamCommentTemplatesPreferencesPage.this.editTemplate();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(this.removeButton);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ModelBusTeamCommentTemplatesPreferencesPage.this.remove();
            }
        });
    }

    protected void newTemplate() {
        EditCommentTemplatePanel panel = new EditCommentTemplatePanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            this.listViewer.add((Object)panel.getTemplate());
        }
    }

    protected void editTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        if (selection.size() == 1) {
            String oldTemplate = (String)selection.getFirstElement();
            EditCommentTemplatePanel panel = new EditCommentTemplatePanel(oldTemplate);
            DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
            if (dialog.open() == 0) {
                this.listViewer.remove((Object)oldTemplate);
                this.listViewer.add((Object)panel.getTemplate());
            }
        }
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.listViewer.remove(selection.toArray());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.userTemplatesEnabled = this.useTemplatesButton.getSelection();
        this.listViewer.getControl().setEnabled(this.userTemplatesEnabled);
        this.newButton.setEnabled(this.userTemplatesEnabled);
        this.previewText.setEnabled(this.userTemplatesEnabled);
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.editButton.setEnabled(this.userTemplatesEnabled && selection.size() == 1);
        this.removeButton.setEnabled(this.userTemplatesEnabled && selection.size() > 0);
        this.previewText.setText(selection.size() == 1 ? (String)selection.getFirstElement() : "");
    }
}

