/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorException;
import org.modelbus.team.eclipse.core.operation.LoggedOperation;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.SpellcheckedTextProvider;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.common.EditAutoPropertiesPanel;
import org.modelbus.team.eclipse.ui.panel.common.EditCustomPropertiesPanel;
import org.modelbus.team.eclipse.ui.preferences.AbstractModelBusTeamPreferencesPage;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;

public class ModelBusTeamPropsPreferencePage
extends AbstractModelBusTeamPreferencesPage {
    protected CheckboxTableViewer autopropTableViewer;
    protected Button autopropBtnAdd;
    protected Button autopropBtnEdit;
    protected Button autopropBtnRemove;
    protected Button autopropBtnExport;
    protected Button autopropBtnImport;
    protected String autoPropsValue;
    protected String customPropsValue;
    protected TableViewer custompropTableViewer;
    protected Button custompropBtnAdd;
    protected Button custompropBtnEdit;
    protected Button custompropBtnRemove;
    protected StyledText customPropDescription;
    public static final int COLUMN_INDEX_FILE_NAME = 1;
    public static final int COLUMN_INDEX_PROPERTIES = 2;
    public static final String AUTO_PROPS_CONFIG_FILE_NAME = "config";
    public static final String AUTO_PROPS_SECTION_HEADER = "[auto-props]";
    public static final String AUTO_PROPS_COMMENT_START = "#";
    public static final String AUTO_PROPS_PATTERN_SEPARATOR = "=";
    public static final String AUTO_PROPS_PROPS_SEPARATOR = ";";

    @Override
    protected void saveValues(IPreferenceStore store) {
        Object property;
        int propsCount = this.autopropTableViewer.getTable().getItemCount();
        String[] props = new String[3 * propsCount];
        int i = 0;
        while (i < propsCount) {
            property = (AutoProperty)this.autopropTableViewer.getElementAt(i);
            props[3 * i] = ((AutoProperty)property).enabled ? "1" : "0";
            props[3 * i + 1] = ((AutoProperty)property).fileName;
            props[3 * i + 2] = ((AutoProperty)property).properties;
            ++i;
        }
        this.autoPropsValue = FileUtility.encodeArrayToString((String[])props);
        ModelBusTeamPreferences.setAutoPropertiesList(store, "autoproperties", this.autoPropsValue);
        propsCount = this.custompropTableViewer.getTable().getItemCount();
        props = new String[3 * propsCount];
        i = 0;
        while (i < propsCount) {
            property = (CustomProperty)this.custompropTableViewer.getElementAt(i);
            props[3 * i] = ((CustomProperty)property).propName;
            props[3 * i + 1] = ((CustomProperty)property).regExp;
            props[3 * i + 2] = ((CustomProperty)property).descriprion;
            ++i;
        }
        this.customPropsValue = FileUtility.encodeArrayToString((String[])props);
        ModelBusTeamPreferences.setCustomPropertiesList(store, "customproperties", this.customPropsValue);
    }

    @Override
    protected void loadDefaultValues(IPreferenceStore store) {
        this.autoPropsValue = "";
        this.customPropsValue = "";
    }

    @Override
    protected void loadValues(IPreferenceStore store) {
        this.autoPropsValue = ModelBusTeamPreferences.getAutoPropertiesList(store, "autoproperties");
        this.customPropsValue = ModelBusTeamPreferences.getCustomPropertiesList(store, "customproperties");
    }

    @Override
    protected void initializeControls() {
        this.removeAllProperties();
        this.populateAutopropTable(ModelBusTeamPropsPreferencePage.loadAutoProperties(this.autoPropsValue));
        this.populateCustompropTable(ModelBusTeamPropsPreferencePage.loadCustomProperties(this.customPropsValue));
    }

    @Override
    protected Control createContentsImpl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Automatic properties");
        tabItem.setControl((Control)this.createAutopropsComposite(tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Custom properties");
        tabItem.setControl((Control)this.createCustompropsComposite(tabFolder));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.modelbus.team.eclipse.help.autoPropsPreferencesContext");
        return tabFolder;
    }

    protected Composite createAutopropsComposite(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createAutopropTable(composite);
        this.createAutopropButtons(composite);
        this.autopropTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ModelBusTeamPropsPreferencePage.this.autopropBtnEdit.setEnabled(selection.size() == 1);
                ModelBusTeamPropsPreferencePage.this.autopropBtnRemove.setEnabled(selection.size() > 0);
            }
        });
        this.autopropTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelBusTeamPropsPreferencePage.this.editAutoProperty();
            }
        });
        this.autopropTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((AutoProperty)event.getElement()).enabled = event.getChecked();
                ModelBusTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(ModelBusTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        this.autopropBtnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.addAutoProperty();
                ModelBusTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(ModelBusTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        this.autopropBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.editAutoProperty();
            }
        });
        this.autopropBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.removeAutoProperty();
                ModelBusTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(ModelBusTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        this.autopropBtnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.exportAutoProperties();
            }
        });
        this.autopropBtnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.importAutoProperties();
                ModelBusTeamPropsPreferencePage.this.autopropBtnExport.setEnabled(ModelBusTeamPropsPreferencePage.this.autopropTableViewer.getCheckedElements().length != 0);
            }
        });
        return composite;
    }

    protected void createAutopropTable(Composite parent) {
        this.autopropTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(75, true));
        this.autopropTableViewer.getTable().setLayout((Layout)layout);
        this.autopropTableViewer.getTable().setLinesVisible(true);
        this.autopropTableViewer.getTable().setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        this.autopropTableViewer.getTable().setLayoutData((Object)data);
        this.autopropTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    return ((AutoProperty)element).fileName;
                }
                if (columnIndex == 2) {
                    return ((AutoProperty)element).properties;
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        TableColumn column = new TableColumn(this.autopropTableViewer.getTable(), 0);
        column.setResizable(false);
        column = new TableColumn(this.autopropTableViewer.getTable(), 0);
        column.setText(ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.columnHeaderFileName"));
        column = new TableColumn(this.autopropTableViewer.getTable(), 0);
        column.setText(ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.columnHeaderProperties"));
    }

    protected void createAutopropButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this.autopropBtnAdd = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextAdd"), true);
        this.autopropBtnEdit = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextEdit"), false);
        this.autopropBtnRemove = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextRemove"), false);
        this.autopropBtnExport = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextExport"), this.autopropTableViewer.getCheckedElements().length != 0);
        this.autopropBtnImport = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextImport"), true);
    }

    protected Button createButton(Composite parent, String text, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(button);
        button.setLayoutData((Object)data);
        button.setEnabled(enabled);
        return button;
    }

    public void addAutoProperty() {
        EditAutoPropertiesPanel panel = new EditAutoPropertiesPanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            AutoProperty property = new AutoProperty(panel.getFileName(), panel.getProperties(), true);
            this.autopropTableViewer.add((Object)property);
            this.autopropTableViewer.setChecked((Object)property, property.enabled);
        }
    }

    public void editAutoProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.autopropTableViewer.getSelection();
        AutoProperty property = (AutoProperty)selection.getFirstElement();
        EditAutoPropertiesPanel panel = new EditAutoPropertiesPanel(property);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            property.fileName = panel.getFileName();
            property.properties = panel.getProperties();
            this.autopropTableViewer.update((Object)property, null);
        }
    }

    public void removeAutoProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.autopropTableViewer.getSelection();
        this.autopropTableViewer.remove(selection.toArray());
    }

    public void removeAllProperties() {
        this.autopropTableViewer.getTable().clearAll();
        this.autopropTableViewer.refresh();
        this.custompropTableViewer.getTable().clearAll();
        this.custompropTableViewer.refresh();
    }

    public void exportAutoProperties() {
        String filePath = this.findConfigFile(ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.dialogTitleExport"));
        if (filePath == null) {
            return;
        }
        File srcCfg = new File(filePath);
        File tmpCfg = null;
        BufferedReader srcReader = null;
        PrintWriter tmpWriter = null;
        try {
            try {
                String line;
                tmpCfg = File.createTempFile("cfg_", String.valueOf(srcCfg.getName()) + "tmp", ModelBusTeamPlugin.instance().getStateLocation().toFile());
                tmpCfg.deleteOnExit();
                if (!srcCfg.exists()) {
                    srcCfg.createNewFile();
                }
                srcReader = new BufferedReader(new FileReader(srcCfg));
                tmpWriter = new PrintWriter(new FileOutputStream(tmpCfg));
                while ((line = srcReader.readLine()) != null && !line.startsWith(AUTO_PROPS_SECTION_HEADER)) {
                    tmpWriter.println(line);
                }
                tmpWriter.println(AUTO_PROPS_SECTION_HEADER);
                while ((line = srcReader.readLine()) != null && !line.trim().equals("")) {
                    tmpWriter.println(line);
                }
                Object[] checkedProps = this.autopropTableViewer.getCheckedElements();
                int i = 0;
                while (i < checkedProps.length) {
                    AutoProperty property = (AutoProperty)checkedProps[i];
                    if (!property.properties.equals("")) {
                        tmpWriter.println(String.valueOf(property.fileName) + " " + AUTO_PROPS_PATTERN_SEPARATOR + " " + property.properties);
                    }
                    ++i;
                }
                while ((line = srcReader.readLine()) != null) {
                    tmpWriter.println(line);
                }
                srcReader.close();
                tmpWriter.close();
                srcCfg.delete();
                tmpCfg.renameTo(srcCfg);
            }
            catch (IOException ioe) {
                LoggedOperation.reportError((String)ModelBusTeamUIPlugin.instance().getResource("Error.ExportProperties"), (Throwable)ioe);
                try {
                    if (srcReader != null) {
                        srcReader.close();
                    }
                }
                catch (IOException iOException) {}
                if (tmpWriter != null) {
                    tmpWriter.close();
                }
                if (tmpCfg != null) {
                    tmpCfg.delete();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (srcReader != null) {
                    srcReader.close();
                }
            }
            catch (IOException iOException) {}
            if (tmpWriter != null) {
                tmpWriter.close();
            }
            if (tmpCfg != null) {
                tmpCfg.delete();
            }
            throw throwable;
        }
        try {
            if (srcReader != null) {
                srcReader.close();
            }
        }
        catch (IOException iOException) {}
        if (tmpWriter != null) {
            tmpWriter.close();
        }
        if (tmpCfg != null) {
            tmpCfg.delete();
        }
    }

    public void importAutoProperties() {
        String filePath = this.findConfigFile(ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.dialogTitleImport"));
        if (filePath == null) {
            return;
        }
        BufferedReader cfgReader = null;
        ArrayList<AutoProperty> autoPropsList = new ArrayList<AutoProperty>();
        try {
            try {
                String line;
                cfgReader = new BufferedReader(new FileReader(filePath));
                while ((line = cfgReader.readLine()) != null) {
                    if (line.startsWith(AUTO_PROPS_SECTION_HEADER)) break;
                }
                Pattern p = Pattern.compile("\\[.*\\]");
                while ((line = cfgReader.readLine()) != null && !p.matcher(line).matches()) {
                    if (line.startsWith(AUTO_PROPS_COMMENT_START) || line.equals("")) continue;
                    String fileName = "";
                    String properties = "";
                    int index = line.indexOf(AUTO_PROPS_PATTERN_SEPARATOR);
                    if (index != -1) {
                        fileName = line.substring(0, index).trim();
                        if (index < line.length() - 1) {
                            properties = line.substring(index + 1).trim();
                        }
                    } else {
                        fileName = line.trim();
                    }
                    autoPropsList.add(new AutoProperty(fileName, properties, true));
                }
                this.populateAutopropTable(autoPropsList.toArray());
            }
            catch (IOException ioe) {
                LoggedOperation.reportError((String)ModelBusTeamUIPlugin.instance().getResource("Error.ImportProperties"), (Throwable)ioe);
                try {
                    if (cfgReader != null) {
                        cfgReader.close();
                    }
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (cfgReader != null) {
                    cfgReader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (cfgReader != null) {
                cfgReader.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void populateAutopropTable(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.autopropTableViewer.add(items[i]);
            this.autopropTableViewer.setChecked(items[i], ((AutoProperty)items[i]).enabled);
            ++i;
        }
    }

    public void populateCustompropTable(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.custompropTableViewer.add(items[i]);
            ++i;
        }
    }

    protected Composite createCustompropsComposite(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createCustompropTable(composite);
        this.createCustompropButtons(composite);
        data = new GridData(768);
        data.heightHint = 80;
        data.widthHint = 0;
        this.customPropDescription = SpellcheckedTextProvider.getTextWidget(composite, data, 578);
        this.customPropDescription.setText(ModelBusTeamUIPlugin.instance().getResource("CustomPropsPreferencePage.description"));
        this.customPropDescription.setEditable(false);
        this.custompropTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ModelBusTeamPropsPreferencePage.this.refreshDescription();
                ModelBusTeamPropsPreferencePage.this.custompropBtnEdit.setEnabled(selection.size() == 1);
                ModelBusTeamPropsPreferencePage.this.custompropBtnRemove.setEnabled(selection.size() > 0);
            }
        });
        this.custompropTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelBusTeamPropsPreferencePage.this.editCustomProperty();
            }
        });
        this.custompropBtnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.addCustomProperty();
            }
        });
        this.custompropBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.editCustomProperty();
            }
        });
        this.custompropBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusTeamPropsPreferencePage.this.removeCustomProperty();
            }
        });
        return composite;
    }

    protected void createCustompropTable(Composite parent) {
        this.custompropTableViewer = new TableViewer(parent, 68354);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        this.custompropTableViewer.getTable().setLayout((Layout)layout);
        this.custompropTableViewer.getTable().setLinesVisible(true);
        this.custompropTableViewer.getTable().setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        this.custompropTableViewer.getTable().setLayoutData((Object)data);
        this.custompropTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((CustomProperty)element).propName;
                }
                if (columnIndex == 1) {
                    return ((CustomProperty)element).regExp;
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        TableColumn column = new TableColumn(this.custompropTableViewer.getTable(), 0);
        column.setText(ModelBusTeamUIPlugin.instance().getResource("CustomPropsPreferencePage.columnHeaderPropName"));
        column = new TableColumn(this.custompropTableViewer.getTable(), 0);
        column.setText(ModelBusTeamUIPlugin.instance().getResource("CustomPropsPreferencePage.columnHeaderRegexp"));
    }

    protected void createCustompropButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this.custompropBtnAdd = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextAdd"), true);
        this.custompropBtnEdit = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextEdit"), false);
        this.custompropBtnRemove = this.createButton(buttons, ModelBusTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextRemove"), false);
    }

    protected void refreshDescription() {
        IStructuredSelection selection = (IStructuredSelection)this.custompropTableViewer.getSelection();
        if (selection.size() == 0) {
            this.customPropDescription.setText(ModelBusTeamUIPlugin.instance().getResource("CustomPropsPreferencePage.description"));
            return;
        }
        String description = ((CustomProperty)selection.getFirstElement()).descriprion;
        if (description.equals("")) {
            this.customPropDescription.setText("No description available.");
        } else {
            this.customPropDescription.setText(description);
        }
    }

    public void addCustomProperty() {
        EditCustomPropertiesPanel panel = new EditCustomPropertiesPanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            this.custompropTableViewer.add((Object)panel.getProperty());
        }
    }

    public void editCustomProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.custompropTableViewer.getSelection();
        CustomProperty property = (CustomProperty)selection.getFirstElement();
        EditCustomPropertiesPanel panel = new EditCustomPropertiesPanel(property);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            property = panel.getProperty();
            this.custompropTableViewer.update((Object)property, null);
            this.refreshDescription();
        }
    }

    public void removeCustomProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.custompropTableViewer.getSelection();
        this.custompropTableViewer.remove(selection.toArray());
        this.refreshDescription();
    }

    public static CustomProperty[] loadCustomProperties(String encodedProps) {
        ArrayList<CustomProperty> propsList = new ArrayList<CustomProperty>();
        String[] props = FileUtility.decodeStringToArray((String)encodedProps);
        int i = 0;
        while (i < props.length) {
            String propName = props[i];
            String regexp = i + 1 == props.length ? "" : props[i + 1];
            String description = i + 2 >= props.length ? "" : props[i + 2];
            CustomProperty property = new CustomProperty(propName, regexp, description);
            propsList.add(property);
            i += 3;
        }
        return propsList.toArray(new CustomProperty[propsList.size()]);
    }

    public static Object[] loadAutoProperties(String encodedProps) {
        ArrayList<AutoProperty> propsList = new ArrayList<AutoProperty>();
        String[] props = FileUtility.decodeStringToArray((String)encodedProps);
        int i = 0;
        while (i < props.length) {
            boolean enabled = !props[i].equals("0");
            String fileName = props[i + 1];
            String properties = i + 2 == props.length ? "" : props[i + 2];
            AutoProperty property = new AutoProperty(fileName, properties, enabled);
            propsList.add(property);
            i += 3;
        }
        return propsList.toArray();
    }

    public String findConfigFile(String dialogTitle) {
        String cfgDir;
        IModelBusConnector connector = ModelBusConnector.getModelBusConnector();
        try {
            cfgDir = connector.getConfigDirectory();
        }
        catch (ModelBusConnectorException cwe) {
            LoggedOperation.reportError((String)ModelBusTeamUIPlugin.instance().getResource("Error.FindConfigFile"), (Throwable)cwe);
            return null;
        }
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setText(dialogTitle);
        dlg.setFilterPath(cfgDir);
        File cfgFile = new File(String.valueOf(cfgDir) + System.getProperty("file.separator") + AUTO_PROPS_CONFIG_FILE_NAME);
        if (cfgFile.exists()) {
            dlg.setFileName(AUTO_PROPS_CONFIG_FILE_NAME);
        }
        return dlg.open();
    }

    public static class AutoProperty {
        public String fileName;
        public String properties;
        public boolean enabled;

        public AutoProperty(String fileName, String properties, boolean enabled) {
            this.fileName = fileName;
            this.properties = properties;
            this.enabled = enabled;
        }
    }

    public static class CustomProperty {
        public String propName;
        public String regExp;
        public String descriprion;

        public CustomProperty(String propName, String regExp, String description) {
            this.propName = propName;
            this.regExp = regExp;
            this.descriprion = description;
        }
    }
}

