/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.extension.factory.PredefinedProperty;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPropsPreferencePage;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositePropertiesVerifier;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.ExistingResourceVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.PropertyNameVerifier;

public abstract class AbstractPropertyEditPanel
extends AbstractDialogPanel {
    protected ModelBusProperty[] source;
    protected HashMap<String, String> alreadyExistent;
    protected Combo nameField;
    protected Text valueField;
    protected Text fileField;
    protected Label descriptionField;
    protected boolean fileSelected;
    protected String propertyName;
    protected String propertyValue;
    protected String propertyFile;
    protected ModelBusTeamPropsPreferencePage.CustomProperty[] customProps;
    protected List<PredefinedProperty> predefinedProperties;
    protected Map<String, String> predefinedPropertiesRegexps;
    protected HashMap<String, AbstractFormattedVerifier> verifiers;

    public AbstractPropertyEditPanel(ModelBusProperty[] propertyData, String dialogTitle, String dialogDescription) {
        if (propertyData != null) {
            this.propertyName = propertyData[0].name;
            this.propertyValue = propertyData[0].value;
        }
        this.customProps = ModelBusTeamPropsPreferencePage.loadCustomProperties(ModelBusTeamPreferences.getCustomPropertiesList(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "customproperties"));
        this.verifiers = new HashMap();
        this.dialogTitle = dialogTitle;
        this.dialogDescription = dialogDescription;
        this.source = propertyData;
        this.fileSelected = false;
        this.predefinedProperties = this.getPredefinedProperties();
        this.predefinedPropertiesRegexps = this.getPredefinedPropertiesRegexps();
        this.alreadyExistent = new HashMap();
        if (propertyData != null) {
            ModelBusProperty[] modelBusPropertyArray = propertyData;
            int n = propertyData.length;
            int n2 = 0;
            while (n2 < n) {
                ModelBusProperty current = modelBusPropertyArray[n2];
                this.alreadyExistent.put(current.name, current.value);
                ++n2;
            }
        }
    }

    public boolean isFileSelected() {
        return this.fileSelected;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    protected ModelBusTeamPropsPreferencePage.CustomProperty getCustomProperty(String name) {
        int i = 0;
        while (i < this.customProps.length) {
            if (this.customProps[i].propName.equals(name)) {
                return this.customProps[i];
            }
            ++i;
        }
        return null;
    }

    public void setPropertyToEdit(ModelBusProperty propertyToEdit) {
        if (propertyToEdit != null) {
            this.propertyName = propertyToEdit.name;
            this.propertyValue = propertyToEdit.value;
        } else {
            this.propertyValue = "";
            this.propertyName = "";
        }
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.Name"));
        this.nameField = new Combo(composite, 0);
        GridData data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setVisibleItemCount(10);
        this.nameField.setItems(this.getPropertyNames(this.predefinedProperties, this.customProps));
        this.nameField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = AbstractPropertyEditPanel.this.nameField.getItem(AbstractPropertyEditPanel.this.nameField.getSelectionIndex());
                String value = AbstractPropertyEditPanel.this.alreadyExistent.get(selected);
                if (value != null) {
                    AbstractPropertyEditPanel.this.valueField.setText(value);
                } else {
                    PredefinedProperty prop = AbstractPropertyEditPanel.this.getPredefinedProperty(selected);
                    if (prop != null) {
                        AbstractPropertyEditPanel.this.valueField.setText(prop.value);
                    }
                }
                AbstractPropertyEditPanel.this.descriptionField.setText(AbstractPropertyEditPanel.this.getDescriptionText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PredefinedProperty prop = AbstractPropertyEditPanel.this.getPredefinedProperty(AbstractPropertyEditPanel.this.nameField.getText());
                if (prop != null) {
                    AbstractPropertyEditPanel.this.valueField.setText(prop.value);
                }
                AbstractPropertyEditPanel.this.descriptionField.setText(AbstractPropertyEditPanel.this.getDescriptionText());
            }
        });
        Composite descriptionComposite = new Composite(composite, 2048);
        data = new GridData(768);
        descriptionComposite.setLayoutData((Object)data);
        GridLayout descriptionLayout = new GridLayout();
        descriptionLayout.horizontalSpacing = 5;
        descriptionLayout.numColumns = 2;
        descriptionComposite.setLayout((Layout)descriptionLayout);
        Label bulb = new Label(descriptionComposite, 0);
        bulb.setImage(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/dialogs/bulb.png").createImage());
        data = new GridData();
        data.verticalAlignment = 128;
        bulb.setLayoutData((Object)data);
        this.descriptionField = new Label(descriptionComposite, 64);
        data = new GridData(768);
        data.verticalAlignment = 128;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 50;
        this.descriptionField.setLayoutData((Object)data);
        this.descriptionField.setText(this.getDescriptionText());
        this.descriptionField.setBackground(this.nameField.getBackground());
        descriptionComposite.setBackground(this.nameField.getBackground());
        bulb.setBackground(this.nameField.getBackground());
        CompositeVerifier verifier = new CompositeVerifier();
        String name = ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.Name.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new PropertyNameVerifier(name));
        this.attachTo((Control)this.nameField, verifier);
        Button editManual = new Button(composite, 16);
        this.valueField = new Text(composite, 2818);
        CompositePropertiesVerifier valueVerifier = new CompositePropertiesVerifier(this.nameField, this.verifiers);
        this.attachTo((Control)this.valueField, valueVerifier);
        data = new GridData();
        editManual.setLayoutData((Object)data);
        editManual.setText(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.EnterValue"));
        editManual.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                AbstractPropertyEditPanel.this.valueField.setEnabled(button.getSelection());
                AbstractPropertyEditPanel.this.fileSelected = false;
                AbstractPropertyEditPanel.this.validateContent();
            }
        });
        editManual.setSelection(true);
        data = new GridData(1808);
        data.heightHint = 100;
        this.valueField.setLayoutData((Object)data);
        this.valueField.selectAll();
        this.valueField.setEnabled(true);
        final Button loadFromFile = new Button(composite, 16);
        Composite subComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        subComposite.setLayout((Layout)layout);
        data = new GridData(768);
        subComposite.setLayoutData((Object)data);
        this.fileField = new Text(subComposite, 2052);
        final Button browse = new Button(subComposite, 8);
        browse.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browse);
        browse.setLayoutData((Object)data);
        browse.setEnabled(false);
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(AbstractPropertyEditPanel.this.manager.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    AbstractPropertyEditPanel.this.fileField.setText(res);
                    AbstractPropertyEditPanel.this.validateContent();
                }
            }
        });
        data = new GridData();
        loadFromFile.setLayoutData((Object)data);
        loadFromFile.setText(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.LoadValue"));
        loadFromFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                AbstractPropertyEditPanel.this.fileField.setEnabled(button.getSelection());
                browse.setEnabled(button.getSelection());
                AbstractPropertyEditPanel.this.fileSelected = true;
                AbstractPropertyEditPanel.this.validateContent();
            }
        });
        data = new GridData(768);
        this.fileField.setLayoutData((Object)data);
        this.fileField.setEnabled(false);
        this.attachTo((Control)this.fileField, new AbstractVerifierProxy(new ExistingResourceVerifier(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.File.Verifier"), true)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return loadFromFile.getSelection();
            }
        });
        if (this.source != null && this.source.length > 0) {
            this.nameField.setText(this.propertyName);
            this.valueField.setText(this.propertyValue);
        }
        this.nameField.setFocus();
    }

    protected abstract List<PredefinedProperty> getPredefinedProperties();

    protected abstract void fillVerifiersMap();

    protected abstract Map<String, String> getPredefinedPropertiesRegexps();

    protected String[] getPropertyNames(List<PredefinedProperty> predefinedProperties, ModelBusTeamPropsPreferencePage.CustomProperty[] customProperties) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<PredefinedProperty> it = predefinedProperties.iterator();
        while (it.hasNext()) {
            names.add(it.next().name);
        }
        names.add(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.custom_description"));
        int i = 0;
        while (i < customProperties.length) {
            names.add(customProperties[i].propName);
            ++i;
        }
        if (this.customProps.length == 0) {
            names.add("    " + ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.custom_hint"));
        }
        String[] propertyNames = names.toArray(new String[names.size()]);
        return propertyNames;
    }

    protected String getDescriptionText() {
        String propName = this.nameField.getText();
        PredefinedProperty prop = this.getPredefinedProperty(propName);
        if (prop != null) {
            return prop.description != null && prop.description.trim().length() > 0 ? prop.description : ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.NoDescription");
        }
        ModelBusTeamPropsPreferencePage.CustomProperty customProp = this.getCustomProperty(propName);
        if (customProp != null && !customProp.descriprion.equals("")) {
            return customProp.descriprion;
        }
        return ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.UserDefined");
    }

    protected PredefinedProperty getPredefinedProperty(String name) {
        int idx = this.predefinedProperties.indexOf(new PredefinedProperty(name));
        if (idx >= 0) {
            return this.predefinedProperties.get(idx);
        }
        return null;
    }

    @Override
    protected void saveChangesImpl() {
        this.propertyName = this.nameField.getText();
        this.propertyValue = this.valueField.getText();
        this.propertyFile = this.fileField.getText();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    public String getDefaultMessage() {
        return ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.DefaultMessage");
    }
}

