/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IResourcePropertyProvider;
import org.modelbus.team.eclipse.core.operation.local.property.GetPropertiesOperation;
import org.modelbus.team.eclipse.core.operation.remote.GetRemotePropertiesOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.AbstractModelBusView;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.PropertiesComposite;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class PropertiesView
extends AbstractModelBusView {
    public static final String VIEW_ID = PropertiesView.class.getName();
    protected PropertiesComposite propertiesComposite;
    protected IResourcePropertyProvider propertyProvider;
    protected IAdaptable adaptable;
    protected Action linkWithEditorAction;
    protected Action linkWithEditorDropDownAction;
    protected boolean backgroundExecution;

    public PropertiesView() {
        super(ModelBusTeamUIPlugin.instance().getResource("PropertiesView.Description"));
    }

    public void setFocus() {
    }

    public void setResource(IAdaptable resource, IResourcePropertyProvider propertyProvider, boolean backgroundExecution) {
        if (resource instanceof IRepositoryResource) {
            this.repositoryResource = (IRepositoryResource)resource;
            this.wcResource = null;
        } else if (resource instanceof IResource) {
            this.wcResource = (IResource)resource;
            this.repositoryResource = null;
        }
        this.adaptable = resource;
        this.propertyProvider = propertyProvider;
        this.backgroundExecution = backgroundExecution;
        this.propertiesComposite.setResource(resource, propertyProvider);
        this.refreshView();
    }

    @Override
    public void refreshView() {
        boolean operationToFollow = this.propertyProvider != null && this.propertyProvider.getExecutionState() != 0;
        this.propertiesComposite.setPending(operationToFollow);
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PropertiesView.this.showResourceLabel();
                PropertiesView.this.propertiesComposite.initializeComposite();
            }
        });
        CompositeOperation composite = new CompositeOperation("Operation.ShowProperties");
        if (this.propertyProvider != null && this.propertyProvider.getExecutionState() != 0) {
            composite.add((IActionOperation)this.propertyProvider);
            composite.add(this.propertiesComposite.getRefreshViewOperation(), new IActionOperation[]{this.propertyProvider});
        } else {
            composite.add(this.propertiesComposite.getRefreshViewOperation());
        }
        if (this.backgroundExecution) {
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)composite);
        } else {
            UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)this, (IActionOperation)composite);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        this.isLinkWithEditorEnabled = ModelBusTeamPreferences.getPropertiesBoolean(store, "linkWithEditor");
        this.propertiesComposite = new PropertiesComposite(parent);
        this.propertiesComposite.setLayoutData(new GridData(1808));
        this.refreshView();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        this.linkWithEditorDropDownAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.LinkWith.Label"), 2){

            public void run() {
                PropertiesView.this.linkWithEditor();
                PropertiesView.this.linkWithEditorAction.setChecked(PropertiesView.this.isLinkWithEditorEnabled);
            }
        };
        this.linkWithEditorDropDownAction.setChecked(this.isLinkWithEditorEnabled);
        actionBarsMenu.add((IAction)this.linkWithEditorDropDownAction);
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.removeAll();
        Action action = new Action(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.Refresh.Label")){

            public void run() {
                PropertiesView.this.refreshAction();
            }
        };
        action.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        tbm.add((IAction)action);
        tbm.add((IAction)this.getLinkWithEditorAction());
        tbm.update(true);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.modelbus.team.eclipse.help.propertiesViewContext");
    }

    @Override
    protected void disconnectView() {
        this.propertiesComposite.disconnectComposite();
        this.wcResource = null;
    }

    protected void refreshAction() {
        if (this.repositoryResource != null) {
            this.propertyProvider = new GetRemotePropertiesOperation(this.repositoryResource);
            this.propertiesComposite.setResource(this.adaptable, this.propertyProvider);
        }
        this.refreshView();
    }

    protected Action getLinkWithEditorAction() {
        this.linkWithEditorAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.LinkWith.Label"), 2){

            public void run() {
                PropertiesView.this.linkWithEditor();
                PropertiesView.this.linkWithEditorDropDownAction.setChecked(PropertiesView.this.isLinkWithEditorEnabled);
            }
        };
        this.linkWithEditorAction.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.LinkWith.ToolTip"));
        this.linkWithEditorAction.setDisabledImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/link_with_disabled.gif"));
        this.linkWithEditorAction.setHoverImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/link_with.gif"));
        this.linkWithEditorAction.setChecked(this.isLinkWithEditorEnabled);
        return this.linkWithEditorAction;
    }

    protected void linkWithEditor() {
        this.isLinkWithEditorEnabled = !this.isLinkWithEditorEnabled;
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        ModelBusTeamPreferences.setPropertiesBoolean(store, "linkWithEditor", this.isLinkWithEditorEnabled);
        if (this.isLinkWithEditorEnabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    @Override
    protected void updateViewInput(IRepositoryResource resource) {
        if (this.repositoryResource != null && this.repositoryResource.equals(resource)) {
            return;
        }
        if (resource != null) {
            this.setResource((IAdaptable)resource, (IResourcePropertyProvider)new GetRemotePropertiesOperation(resource), true);
        }
    }

    @Override
    protected void updateViewInput(IResource resource) {
        ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(resource);
        if (IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED.accept(local)) {
            if (local.getResource().equals((Object)this.wcResource)) {
                return;
            }
            this.setResource((IAdaptable)resource, (IResourcePropertyProvider)new GetPropertiesOperation(resource), true);
        }
    }

    @Override
    protected boolean needsLinkWithEditorAndSelection() {
        return true;
    }
}

