/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.properties;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.ApplyPropertyMethodComposite;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.extension.factory.PredefinedProperty;
import org.modelbus.team.eclipse.ui.properties.AbstractPropertyEditPanel;
import org.modelbus.team.eclipse.ui.verifier.PropertyVerifier;

public class ResourcePropertyEditPanel
extends AbstractPropertyEditPanel {
    public static int SINGLE_FILE = 0;
    public static int MULTIPLE_FILES = 1;
    public static int MIXED_RESOURCES = 2;
    protected Button recursiveButton;
    protected ApplyPropertyMethodComposite applyComposite;
    protected int resourcesType;
    protected boolean recursiveSelected;
    protected boolean applyToAll;
    protected boolean applyToFiles;
    protected boolean applyToFolders;
    protected IResource[] selectedResources;
    protected boolean strict;

    public ResourcePropertyEditPanel(ModelBusProperty[] data, IResource[] selectedResources, boolean strict) {
        super(data, ModelBusTeamUIPlugin.instance().getResource(data != null ? "PropertyEditPanel.Title.Edit" : "PropertyEditPanel.Title.Add"), ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Description"));
        this.strict = strict;
        this.selectedResources = selectedResources;
        this.resourcesType = this.computeResourcesType();
        this.fillVerifiersMap();
    }

    @Override
    protected void fillVerifiersMap() {
        String[] properties = this.predefinedPropertiesRegexps.keySet().toArray(new String[0]);
        IRepositoryResource base = ModelBusRemoteStorage.instance().asRepositoryResource(this.selectedResources[0]);
        int i = 0;
        while (i < properties.length) {
            this.verifiers.put(properties[i], new PropertyVerifier("EditPropertiesInputField", (String)this.predefinedPropertiesRegexps.get(properties[i]), properties[i], base));
            ++i;
        }
        i = 0;
        while (i < this.customProps.length) {
            this.verifiers.put(this.customProps[i].propName, new PropertyVerifier("EditPropertiesInputField", this.customProps[i].regExp.equals("") ? null : this.customProps[i].regExp, this.customProps[i].propName, base));
            ++i;
        }
    }

    @Override
    protected List<PredefinedProperty> getPredefinedProperties() {
        return ExtensionsManager.getInstance().getPredefinedPropertySet().getPredefinedProperties();
    }

    @Override
    protected Map<String, String> getPredefinedPropertiesRegexps() {
        return ExtensionsManager.getInstance().getPredefinedPropertySet().getPredefinedPropertiesRegexps();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isRecursiveSelected() {
        return this.recursiveSelected;
    }

    public int getApplyMethod() {
        return this.applyComposite == null ? 0 : this.applyComposite.getApplyMethod();
    }

    public String getFilterMask() {
        return this.applyComposite == null ? "" : this.applyComposite.getFilterMask();
    }

    public boolean useMask() {
        return this.applyComposite == null ? false : this.applyComposite.useMask();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        super.createControlsImpl(parent);
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
                this.recursiveButton = new Button(parent, 32);
                this.recursiveButton.setText(ModelBusTeamUIPlugin.instance().getResource("PropertyEditPanel.Recursively"));
                this.recursiveButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ResourcePropertyEditPanel.this.refreshControlsEnablement();
                        ResourcePropertyEditPanel.this.validateContent();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            this.applyComposite = new ApplyPropertyMethodComposite(parent, 0, this, this.resourcesType);
            this.applyComposite.setLayoutData(new GridData(768));
        }
        if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
            this.refreshControlsEnablement();
        }
    }

    @Override
    public String getHelpId() {
        return "org.modelbus.team.eclipse.help.setPropsDialogContext";
    }

    protected int computeResourcesType() {
        boolean singleResource = this.selectedResources.length == 1;
        boolean allFiles = true;
        int i = 0;
        while (i < this.selectedResources.length) {
            if (!(this.selectedResources[i] instanceof IFile)) {
                allFiles = false;
                break;
            }
            ++i;
        }
        if (allFiles) {
            return singleResource ? SINGLE_FILE : MULTIPLE_FILES;
        }
        return MIXED_RESOURCES;
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
        if (this.resourcesType != SINGLE_FILE) {
            if (this.resourcesType == MIXED_RESOURCES && !this.strict) {
                this.recursiveSelected = this.recursiveButton.getSelection();
            }
            if (this.applyComposite.isEnabled()) {
                this.applyComposite.saveChanges();
            }
        }
    }

    protected void refreshControlsEnablement() {
        this.applyComposite.setEnabled(this.recursiveButton.getSelection());
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(590, -1);
    }
}

