/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.properties;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.events.RevisonPropertyChangeEvent;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.property.IRevisionPropertiesProvider;
import org.modelbus.team.eclipse.core.operation.remote.SetRevisionPropertyOperation;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.extension.factory.PredefinedProperty;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPropsPreferencePage;
import org.modelbus.team.eclipse.ui.properties.AbstractPropertyEditPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.verifier.PropertyVerifier;

public class RevPropertiesEditPanel
extends AbstractPropertyEditPanel {
    protected ModelBusRevision revision;

    public RevPropertiesEditPanel(ModelBusProperty[] revProperties, ModelBusRevision revision) {
        super(revProperties, ModelBusTeamUIPlugin.instance().getResource("RevisionPropertyEditPanel.Title"), ModelBusTeamUIPlugin.instance().getResource("RevisionPropertyEditPanel.Description", new String[]{String.valueOf(revision)}));
        Object current2;
        this.revision = revision;
        ArrayList<ModelBusTeamPropsPreferencePage.CustomProperty> customPropList = new ArrayList<ModelBusTeamPropsPreferencePage.CustomProperty>(Arrays.asList(this.customProps));
        ArrayList<String> givenNames = new ArrayList<String>();
        ModelBusTeamPropsPreferencePage.CustomProperty[] customPropertyArray = this.customProps;
        int n = this.customProps.length;
        int n2 = 0;
        while (n2 < n) {
            current2 = customPropertyArray[n2];
            givenNames.add(((ModelBusTeamPropsPreferencePage.CustomProperty)current2).propName);
            ++n2;
        }
        for (Object current2 : this.predefinedProperties) {
            givenNames.add(((PredefinedProperty)current2).name);
        }
        customPropertyArray = revProperties;
        n = revProperties.length;
        int n3 = 0;
        while (n3 < n) {
            current2 = customPropertyArray[n3];
            if (!givenNames.contains(((ModelBusProperty)current2).name)) {
                customPropList.add(new ModelBusTeamPropsPreferencePage.CustomProperty(((ModelBusProperty)current2).name, "", ""));
            }
            ++n3;
        }
        this.customProps = customPropList.toArray(new ModelBusTeamPropsPreferencePage.CustomProperty[customPropList.size()]);
        this.fillVerifiersMap();
    }

    @Override
    protected void saveChangesImpl() {
        super.saveChangesImpl();
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void fillVerifiersMap() {
        for (PredefinedProperty current : this.predefinedProperties) {
            this.verifiers.put(current.name, new PropertyVerifier("EditPropertiesInputField", current.name.equals("modelbus:autoversioned") ? null : "", current.name, null));
        }
    }

    @Override
    protected List<PredefinedProperty> getPredefinedProperties() {
        ArrayList<PredefinedProperty> properties = new ArrayList<PredefinedProperty>();
        properties.add(new PredefinedProperty(ModelBusTeamUIPlugin.instance().getResource("AbstractPropertyEditPanel.modelbus_description"), "", ""));
        properties.add(new PredefinedProperty("modelbus:log", this.getDescription("ModelBus.Log"), ""));
        properties.add(new PredefinedProperty("modelbus:author", this.getDescription("ModelBus.Author"), ""));
        properties.add(new PredefinedProperty("modelbus:date", this.getDescription("ModelBus.Date"), ""));
        properties.add(new PredefinedProperty("modelbus:autoversioned", this.getDescription("ModelBus.Autoversioned"), ""));
        return properties;
    }

    protected String getDescription(String id) {
        return ModelBusTeamUIPlugin.instance().getResource("Property." + id);
    }

    @Override
    protected Map<String, String> getPredefinedPropertiesRegexps() {
        return Collections.emptyMap();
    }

    public static void doSetRevisionProperty(RevPropertiesEditPanel panel, final ModelBusRevision revision) {
        final ModelBusProperty[] data = new ModelBusProperty[]{new ModelBusProperty(panel.getPropertyName(), panel.getPropertyValue())};
        SetRevisionPropertyOperation setPropOp = null;
        CompositeOperation op = new CompositeOperation("");
        if (panel.isFileSelected()) {
            final File f = new File(panel.getPropertyFile());
            AbstractActionOperation loadOp = new AbstractActionOperation("Operation.SLoadFileContent"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    FileInputStream input = null;
                    try {
                        input = new FileInputStream(f);
                        byte[] binary = new byte[(int)f.length()];
                        input.read(binary);
                        data[0] = new ModelBusProperty(data[0].name, new String(binary));
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
            };
            op.add((IActionOperation)loadOp);
            IRevisionPropertiesProvider provider = new IRevisionPropertiesProvider(){

                public ModelBusProperty[] getRevisionProperties() {
                    return data;
                }
            };
            setPropOp = new SetRevisionPropertyOperation(revision, provider);
        } else {
            setPropOp = new SetRevisionPropertyOperation(revision, data[0]);
        }
        op.setOperationName(setPropOp.getOperationName());
        op.add((IActionOperation)setPropOp);
        op.add((IActionOperation)new AbstractActionOperation(setPropOp.getOperationName()){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ModelBusRemoteStorage.instance().fireRevisionPropertyChangeEvent(new RevisonPropertyChangeEvent(0, revision, data[0]));
            }
        }, new IActionOperation[]{setPropOp});
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
    }
}

