/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.events.IRepositoriesStateChangedListener;
import org.modelbus.team.eclipse.core.modelbusstorage.events.IRevisionPropertyChangeListener;
import org.modelbus.team.eclipse.core.modelbusstorage.events.RepositoriesStateChangedEvent;
import org.modelbus.team.eclipse.core.modelbusstorage.events.RevisonPropertyChangeEvent;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.property.IRevisionPropertiesProvider;
import org.modelbus.team.eclipse.core.operation.remote.GetRevisionPropertiesOperation;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.RevisionPropertiesComposite;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class RevPropertiesView
extends ViewPart
implements IRepositoriesStateChangedListener,
IRevisionPropertyChangeListener {
    public static final String VIEW_ID = RevPropertiesView.class.getName();
    protected ModelBusRevision revision;
    protected IRevisionPropertiesProvider provider;
    protected IActionOperation toPerform;
    protected RevisionPropertiesComposite revPropComposite;

    public RevPropertiesView() {
        ModelBusRemoteStorage.instance().addRepositoriesStateChangedListener((IRepositoriesStateChangedListener)this);
        ModelBusRemoteStorage.instance().addRevisionPropertyChangeListener((IRevisionPropertyChangeListener)this);
    }

    public void setLocationAndRevision(ModelBusRevision revision) {
        this.revision = revision;
        this.revPropComposite.setLocationAndRevision(revision);
        this.refreshView();
    }

    public void refreshView() {
        if (this.revision == null) {
            this.setContentDescription("");
            return;
        }
        this.setContentDescription(ModelBusTeamUIPlugin.instance().getResource("RevisionPropertyView.Decript", new String[]{String.valueOf(this.revision)}));
        this.revPropComposite.setPending(true);
        CompositeOperation op = new CompositeOperation("ShowRevProp");
        this.provider = new GetRevisionPropertiesOperation(this.revision);
        op.add((IActionOperation)this.provider);
        op.add((IActionOperation)new AbstractActionOperation("ShowRevProp"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                RevPropertiesView.this.revPropComposite.setInput(RevPropertiesView.this.provider.getRevisionProperties());
                RevPropertiesView.this.revPropComposite.setPending(false);
            }
        });
        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
    }

    public void createPartControl(Composite parent) {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        Action action = new Action(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.Refresh.Label")){

            public void run() {
                RevPropertiesView.this.refreshView();
            }
        };
        action.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        tbm.add((IAction)action);
        tbm.update(true);
        this.revPropComposite = new RevisionPropertiesComposite(parent);
        this.refreshView();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.modelbus.team.eclipse.help.revPropertiesViewContext");
    }

    protected void disconnectView() {
        this.revision = null;
        this.revPropComposite.setInput(new ModelBusProperty[0]);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RevPropertiesView.this.setContentDescription("");
            }
        });
    }

    public void dispose() {
        ModelBusRemoteStorage.instance().removeRepositoriesStateChangedListener((IRepositoriesStateChangedListener)this);
        ModelBusRemoteStorage.instance().removeRevisionPropertyChangeListener((IRevisionPropertyChangeListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void repositoriesStateChanged(RepositoriesStateChangedEvent event) {
        if (event.getAction() == 1) {
            this.disconnectView();
        }
    }

    public void revisionPropertyChanged(RevisonPropertyChangeEvent event) {
        ArrayList<ModelBusProperty> props = new ArrayList<ModelBusProperty>(Arrays.asList(this.revPropComposite.getSetProps()));
        boolean isNewProp = true;
        for (ModelBusProperty current : props) {
            if (!current.name.equals(event.getProperty().name)) continue;
            int idx = props.indexOf(current);
            props.set(idx, event.getProperty());
            isNewProp = false;
        }
        if (isNewProp) {
            props.add(event.getProperty());
        }
        final ModelBusProperty[] toSet = props.toArray(new ModelBusProperty[props.size()]);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RevPropertiesView.this.revPropComposite.setInput(toSet);
            }
        });
    }
}

