/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.properties.bugtraq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.modelbus.team.eclipse.ui.properties.bugtraq.BugtraqModel;
import org.modelbus.team.eclipse.ui.properties.bugtraq.LinkList;

public class IssueList
extends LinkList {
    public void parseMessage(String message, BugtraqModel model) {
        String prefix = "";
        String suffix = "";
        String issueRegex = ".*";
        String innerRegExp = null;
        if (model.getLogregex() != null) {
            issueRegex = model.getLogregex()[0];
            if (model.isDoubleLogRegexp()) {
                innerRegExp = model.getLogregex()[1];
            }
        } else if (model.getMessage() != null) {
            String template = model.getMessage();
            prefix = this.getTemplatePrefix(template);
            suffix = this.getTemplateSuffix(template);
            if (model.isNumber()) {
                issueRegex = "[0-9]+(?:,[0-9]+)*";
                innerRegExp = "[0-9]+";
            }
        } else {
            return;
        }
        String regex = String.valueOf(prefix) + issueRegex + suffix;
        Matcher matcher = Pattern.compile(regex, 8).matcher(message);
        while (matcher.find()) {
            if (innerRegExp == null) {
                int i = 1;
                while (i <= matcher.groupCount()) {
                    this.links.add(new LinkList.LinkPlacement(matcher.start(i), matcher.end(i), message));
                    ++i;
                }
                continue;
            }
            String group = matcher.group();
            Matcher entryMatcher = Pattern.compile(innerRegExp).matcher(group);
            while (entryMatcher.find()) {
                this.links.add(new LinkList.LinkPlacement(matcher.start() + entryMatcher.start(), matcher.start() + entryMatcher.end(), message));
            }
        }
    }

    protected String getTemplatePrefix(String template) {
        int indexOfIssue = template.indexOf("%BUGID%");
        String prefix = "";
        if (indexOfIssue > 0) {
            prefix = this.maskRegExpEntries(template.substring(0, indexOfIssue));
        }
        return prefix;
    }

    protected String getTemplateSuffix(String template) {
        int indexOfSuffix;
        int indexOfIssue = template.indexOf("%BUGID%");
        String suffix = "";
        if (indexOfIssue != -1 && (indexOfSuffix = indexOfIssue + "%BUGID%".length()) < template.length()) {
            suffix = this.maskRegExpEntries(template.substring(indexOfSuffix));
        }
        return suffix;
    }

    protected String maskRegExpEntries(String original) {
        String retVal = "";
        int i = 0;
        while (i < original.length()) {
            if ("*\\/:.,?^&+()|".indexOf(original.charAt(i)) != -1) {
                retVal = String.valueOf(retVal) + "\\" + original.charAt(i);
            } else if (original.charAt(i) == '\n') {
                retVal = String.valueOf(retVal) + "(?:\r|\n|\r\n)";
            } else if (original.charAt(i) == '\r') {
                if (i + 1 < original.length() && original.charAt(i + 1) == '\n') {
                    ++i;
                }
                retVal = String.valueOf(retVal) + "(?:\r|\n|\r\n)";
            } else {
                retVal = String.valueOf(retVal) + original.charAt(i);
            }
            ++i;
        }
        return retVal;
    }
}

