/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.events.IRepositoriesStateChangedListener;
import org.modelbus.team.eclipse.core.modelbusstorage.events.RepositoriesStateChangedEvent;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractModelBusTeamAction;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.action.remote.CreateFolderAction;
import org.modelbus.team.eclipse.ui.action.remote.DeleteAction;
import org.modelbus.team.eclipse.ui.action.remote.OpenFileAction;
import org.modelbus.team.eclipse.ui.action.remote.OpenFileWithAction;
import org.modelbus.team.eclipse.ui.action.remote.RefreshAction;
import org.modelbus.team.eclipse.ui.action.remote.management.CreateProjectStructureAction;
import org.modelbus.team.eclipse.ui.action.remote.management.DiscardRevisionLinksAction;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.repository.RepositoryTreeViewer;
import org.modelbus.team.eclipse.ui.repository.browser.RepositoryBrowser;
import org.modelbus.team.eclipse.ui.repository.model.RepositoriesRoot;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryContentProvider;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryLabelProvider;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class RepositoriesView
extends ViewPart {
    public static final String VIEW_ID = RepositoriesView.class.getName();
    protected RepositoryTreeViewer repositoryTree;
    protected RepositoriesRoot root;
    protected DrillDownAdapter ddAdapter;
    protected Action showBrowserAction;
    protected IPartListener2 partListener;

    public static MenuManager newMenuInstance(final ISelectionProvider provider) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object item;
                MenuManager sub = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.New"), "addMenu");
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("managementGroup"));
                sub.add((IContributionItem)new Separator("repositoryGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("checkoutGroup"));
                sub = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.OpenWith"), "openWithMenu");
                sub.add((IContributionItem)new Separator("dynamicGroup"));
                IStructuredSelection selection = (IStructuredSelection)provider.getSelection();
                if (selection.size() == 1 && (item = selection.getFirstElement()) instanceof RepositoryFile) {
                    String name = ((RepositoryFile)item).getRepositoryResource().getName();
                    IEditorDescriptor[] editors = ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getEditors(name);
                    int i = 0;
                    while (i < editors.length) {
                        if (!editors[i].getId().equals("org.eclipse.ui.DefaultTextEditor")) {
                            final OpenFileWithAction openAction = new OpenFileWithAction(editors[i].getId(), false);
                            Action wrapper = new Action(editors[i].getLabel()){

                                public void run() {
                                    openAction.run((IAction)this);
                                }
                            };
                            openAction.selectionChanged((IAction)wrapper, (ISelection)selection);
                            sub.add((IAction)wrapper);
                        }
                        ++i;
                    }
                }
                sub.add((IContributionItem)new Separator("fixedGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("miscGroup"));
                sub = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Refactor"), "refactorMenu");
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("locationGroup"));
                manager.add((IContributionItem)new Separator("propertiesGroup"));
                manager.add((IContributionItem)new Separator("importExportGroup"));
                sub = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.CompareWith"), "compareMenu");
                sub.add((IContributionItem)new Separator("mainGroup"));
                sub.add((IContributionItem)new Separator("additions"));
                manager.prependToGroup("importExportGroup", (IContributionItem)sub);
                manager.add((IContributionItem)new Separator("refreshGroup"));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        return menuMgr;
    }

    public void createPartControl(Composite parent) {
        this.repositoryTree = new RepositoryTreeViewer(parent, 770);
        this.repositoryTree.setContentProvider((IContentProvider)new RepositoryContentProvider(this.repositoryTree));
        this.repositoryTree.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.repositoryTree);
        try {
            this.root = new RepositoriesRoot();
            this.repositoryTree.setInput(this.root);
        }
        catch (Exception exception) {
            this.repositoryTree.setInput(null);
            this.root = null;
        }
        this.ddAdapter = new DrillDownAdapter((TreeViewer)this.repositoryTree);
        Tree tree = this.repositoryTree.getTree();
        MenuManager menuMgr = RepositoriesView.newMenuInstance((ISelectionProvider)this.repositoryTree);
        tree.setMenu(menuMgr.createContextMenu((Control)tree));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.repositoryTree);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.ddAdapter.addNavigationActions(tbm);
        Action tAction = null;
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.Refresh.Label")){

            public void run() {
                if (RepositoriesView.this.repositoryTree.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.repositoryTree.getSelection();
                    RepositoriesView.this.handleRefresh(selection);
                }
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        tAction.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("ModelBusView.Refresh.ToolTip"));
        tbm.add((IContributionItem)new Separator("collapseAllGroup"));
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.CollapseAll.Label")){

            public void run() {
                RepositoriesView.this.repositoryTree.collapseAll();
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/collapseall.gif"));
        tAction.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.CollapseAll.ToolTip"));
        tbm.add((IContributionItem)new Separator("repositoryGroup"));
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CreateRemoteFolderAction.label")){

            public void run() {
                new CreateFolderAction(true).run((IAction)this);
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/repositories/newfolder.gif"));
        tAction.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("CreateRemoteFolderAction.tooltip"));
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("CreateProjectStructureAction.label")){

            public void run() {
                new CreateProjectStructureAction(true).run((IAction)this);
            }
        };
        tbm.add((IAction)tAction);
        tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/objects/root.gif"));
        tAction.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("CreateProjectStructureAction.tooltip"));
        this.showBrowserAction = new Action(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.ShowBrowser.Label"), 2){

            public void run() {
                if (this.isChecked()) {
                    RepositoriesView.this.showRepositoryBrowser(true);
                } else {
                    RepositoriesView.this.hideRepositoryBrowser();
                }
            }
        };
        tbm.add((IAction)this.showBrowserAction);
        this.showBrowserAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/repositories/browser.gif"));
        this.showBrowserAction.setToolTipText(ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.ShowBrowser.ToolTip"));
        this.repositoryTree.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (RepositoriesView.this.repositoryTree.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.repositoryTree.getSelection();
                    if (event.keyCode == 0x100000E) {
                        RepositoriesView.this.handleRefresh(selection);
                    } else if (event.keyCode == 127) {
                        RepositoriesView.this.handleDeleteKey(selection);
                    }
                }
            }
        });
        this.repositoryTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    RepositoriesView.this.handleDoubleClick(structured);
                }
            }
        });
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(VIEW_ID)) {
                    try {
                        RepositoriesView.this.refreshRepositoriesImpl(false);
                    }
                    catch (Exception e) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
                        }
                        catch (PartInitException e1) {
                            e1.printStackTrace();
                        }
                        ModelBusTeamUIPlugin.instance().getLog().log((IStatus)new Status(4, ModelBusTeamUIPlugin.instance().getDescriptor().getUniqueIdentifier(), 4, e.getMessage(), (Throwable)e));
                    }
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(RepositoryBrowser.VIEW_ID)) {
                    RepositoriesView.this.getViewSite().getPage().removePartListener((IPartListener2)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.partListener);
        ModelBusRemoteStorage.instance().addRepositoriesStateChangedListener(new IRepositoriesStateChangedListener(){

            public void repositoriesStateChanged(RepositoriesStateChangedEvent event) {
                if (event.getAction() == 0) {
                    RepositoriesView.refreshRepositories(false);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.modelbus.team.eclipse.help.repositoryViewContext");
    }

    public void dispose() {
        super.dispose();
        this.getViewSite().getPage().removePartListener(this.partListener);
    }

    public void setFocus() {
        this.repositoryTree.getControl().setFocus();
    }

    public static void refresh(Object where) {
        RepositoriesView.refresh(where, null);
    }

    public static void refresh(Object where, RepositoryTreeViewer.IRefreshVisitor visitor) {
        RepositoriesView instance = RepositoriesView.instance();
        if (instance != null) {
            instance.repositoryTree.refresh(where, visitor, false);
        }
    }

    public static void refreshRepositories(boolean deep) {
        RepositoriesView instance = RepositoriesView.instance();
        if (instance != null) {
            instance.refreshRepositoriesImpl(deep);
        }
    }

    public RepositoryTreeViewer getRepositoryTree() {
        return this.repositoryTree;
    }

    public void refreshButtonsState() {
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        boolean isBrowserVisible = ModelBusTeamPreferences.getRepositoryBoolean(store, "repositoryBrowser");
        if (this.showBrowserAction != null) {
            this.showBrowserAction.setChecked(isBrowserVisible);
        }
    }

    public static RepositoriesView instance() {
        final RepositoriesView[] view = new RepositoriesView[1];
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = ModelBusTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null) {
                    view[0] = (RepositoriesView)window.getActivePage().findView(VIEW_ID);
                }
            }
        });
        return view[0];
    }

    protected void refreshRepositoriesImpl(boolean deep) {
        if (this.root == null) {
            try {
                this.root = new RepositoriesRoot();
                this.repositoryTree.setInput(this.root);
            }
            catch (Exception exception) {
                this.root = null;
            }
        }
        if (this.root == null) {
            return;
        }
        if (deep) {
            this.root.refresh();
        } else {
            this.root.softRefresh();
        }
        this.repositoryTree.refresh();
    }

    protected void showRepositoryBrowser(boolean force) {
        final IWorkbenchPage page = this.getSite().getPage();
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new AbstractActionOperation("Operation.ShowBrowser"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                RepositoryBrowser browser = (RepositoryBrowser)page.showView(RepositoryBrowser.VIEW_ID);
                ISelection selection = RepositoriesView.this.repositoryTree.getSelection();
                browser.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RepositoriesView.this.repositoryTree, selection));
            }
        });
    }

    protected void hideRepositoryBrowser() {
        IWorkbenchPage page = this.getSite().getPage();
        IViewPart part = page.findView(RepositoryBrowser.VIEW_ID);
        if (part != null) {
            page.hideView(part);
        }
    }

    protected void handleRefresh(IStructuredSelection selection) {
        Action tmp = new Action(){};
        RefreshAction action = null;
        action = new RefreshAction();
        if (selection instanceof TreeSelection && selection.isEmpty()) {
            RepositoriesRoot input = (RepositoriesRoot)this.getRepositoryTree().getInput();
            if (input != null) {
                action.selectionChanged((IAction)tmp, (ISelection)new StructuredSelection(input.getChildren(null)));
            }
        } else {
            action.selectionChanged((IAction)tmp, (ISelection)selection);
        }
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        }
    }

    protected void handleDeleteKey(IStructuredSelection selection) {
        Action tmp = new Action(){};
        AbstractRepositoryTeamAction action = new DeleteAction();
        action.selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        } else {
            action = new DiscardRevisionLinksAction();
            action.selectionChanged((IAction)tmp, (ISelection)selection);
            action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
            if (tmp.isEnabled()) {
                action.run((IAction)tmp);
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        Action tmp = new Action(){};
        OpenFileAction action = new OpenFileAction();
        ((AbstractModelBusTeamAction)action).selectionChanged((IAction)tmp, (ISelection)selection);
        action.setActivePart((IAction)tmp, (IWorkbenchPart)this);
        if (tmp.isEnabled()) {
            action.run((IAction)tmp);
        }
    }

    public boolean canGoBack() {
        return this.ddAdapter.canGoBack();
    }

    public void goBack() {
        this.ddAdapter.goBack();
    }
}

