/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.browser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.ui.repository.model.IParentTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryError;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFolder;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryPending;
import org.modelbus.team.eclipse.ui.repository.preferences.PreferenceInitializer;

public class RepositoryBrowserContentProvider
extends BaseWorkbenchContentProvider {
    protected ComposedAdapterFactory composedAdapterFactory;
    protected AdapterFactoryContentProvider adapterFactoryContentProvider;

    public RepositoryBrowserContentProvider() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        this.composedAdapterFactory = new ComposedAdapterFactory(factories);
        this.adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.composedAdapterFactory);
    }

    private boolean isModelToBrowse(String path) {
        List<String> modelExtensions = Arrays.asList(this.getModelExtensions());
        URI uri = URI.createURI((String)path);
        String fileExtension = uri.fileExtension();
        for (String modelExtension : modelExtensions) {
            if (modelExtension.startsWith("*.")) {
                modelExtension = modelExtension.substring(1);
            }
            if (modelExtension.startsWith(".") && path.endsWith(modelExtension)) {
                return true;
            }
            if (!modelExtension.equals(fileExtension)) continue;
            return true;
        }
        return false;
    }

    private String[] getModelExtensions() {
        String[] modelExtensions = new String[]{};
        modelExtensions = PreferenceInitializer.getExtensionPreference();
        return modelExtensions;
    }

    public boolean hasChildren(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter instanceof IParentTreeNode) {
            return ((IParentTreeNode)adapter).hasChildren();
        }
        if (adapter instanceof RepositoryFile) {
            String path = ((RepositoryFile)adapter).getRepositoryResource().getUrl();
            if (this.isModelToBrowse(path)) {
                return true;
            }
        } else {
            if (adapter == null && element instanceof EObject) {
                if (((EObject)element).eIsProxy()) {
                    return true;
                }
                return this.adapterFactoryContentProvider.hasChildren(element);
            }
            if (adapter == null && element instanceof DelegatingWrapperItemProvider) {
                this.adapterFactoryContentProvider.hasChildren(element);
                return this.adapterFactoryContentProvider.hasChildren(element);
            }
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        IWorkbenchAdapter adapter = this.getAdapter(parentElement);
        if (adapter instanceof RepositoryFolder) {
            RepositoryFolder folder = (RepositoryFolder)adapter;
            Object[] children = folder.peekChildren(parentElement);
            if (folder.getParent() == null) {
                return children;
            }
            if (children.length != 0 && children[0] != null && (children[0] instanceof RepositoryError || children[0] instanceof RepositoryPending)) {
                return children;
            }
            Object[] childrenWithParent = new Object[children.length + 1];
            childrenWithParent[0] = new RepositoryFictiveWorkingDirectory(parentElement);
            System.arraycopy(children, 0, childrenWithParent, 1, children.length);
            return childrenWithParent;
        }
        if (adapter instanceof RepositoryFile) {
            return new Object[0];
        }
        if (adapter == null && parentElement instanceof EObject) {
            EObject eObject = (EObject)parentElement;
            if (eObject.eIsProxy()) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI proxyURI = ((InternalEObject)eObject).eProxyURI();
                String resourceUri = proxyURI.trimFragment().toString();
                String fragment = proxyURI.fragment();
                HashMap<String, BasicResourceHandler> options = new HashMap<String, BasicResourceHandler>();
                if (resourceUri.endsWith(".emx") || resourceUri.endsWith(".epx")) {
                    options.put("RESOURCE_HANDLER", new BasicResourceHandler());
                }
                Resource resource = resourceSet.createResource(URI.createURI((String)resourceUri));
                IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                try {
                    try {
                        repositoryHelper.checkOutModel(UserSessionHelper.getSession(), resource, options);
                    }
                    catch (RepositoryAuthentificationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (UnresolvedReferencesException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NonExistingResourceException e) {
                        throw new RuntimeException(e);
                    }
                    parentElement = resource.getEObject(fragment);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.adapterFactoryContentProvider.getChildren((Object)((EObject)parentElement));
        }
        if (adapter == null && parentElement instanceof DelegatingWrapperItemProvider) {
            return this.adapterFactoryContentProvider.getChildren(parentElement);
        }
        return super.getChildren(parentElement);
    }
}

