/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusLock;
import org.modelbus.team.eclipse.core.operation.LoggedOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.repository.browser.RepositoryBrowserTableViewer;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFictiveNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryResource;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;

public class RepositoryBrowserLabelProvider
implements ITableLabelProvider {
    protected Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
    protected ComposedAdapterFactory composedAdapterFactory;
    protected AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    protected static String hasProps;
    protected static String noAuthor;
    protected static String noDate;

    public RepositoryBrowserLabelProvider(RepositoryBrowserTableViewer tableViewer) {
        noAuthor = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoAuthor");
        noDate = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoDate");
        hasProps = ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Browser.HasProps");
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        this.composedAdapterFactory = new ComposedAdapterFactory(factories);
        this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ImageDescriptor iDescr = null;
            if (element instanceof RepositoryResource) {
                iDescr = ((RepositoryResource)element).getImageDescriptor(null);
            } else if (element instanceof RepositoryFictiveNode) {
                iDescr = ((RepositoryFictiveNode)element).getImageDescriptor(null);
            }
            if (iDescr != null) {
                Image img = this.images.get(iDescr);
                if (img == null) {
                    img = iDescr.createImage();
                    this.images.put(iDescr, img);
                }
                return img;
            }
            if (iDescr == null && (element instanceof EObject || element instanceof DelegatingWrapperItemProvider)) {
                return this.adapterFactoryLabelProvider.getColumnImage(element, columnIndex);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof RepositoryResource) {
            return this.getColumnTextForElement(element, columnIndex);
        }
        if (element instanceof RepositoryFictiveNode) {
            if (columnIndex == 0) {
                return ((RepositoryFictiveNode)element).getLabel(null);
            }
            if (element instanceof RepositoryFictiveWorkingDirectory) {
                return this.getColumnTextForElement(((RepositoryFictiveWorkingDirectory)element).getAssociatedDirectory(), columnIndex);
            }
        } else {
            if (element instanceof EObject) {
                if (columnIndex == 0) {
                    if (((EObject)element).eIsProxy()) {
                        return "";
                    }
                    return this.adapterFactoryLabelProvider.getColumnText(element, columnIndex);
                }
                return "";
            }
            if (element instanceof DelegatingWrapperItemProvider) {
                if (columnIndex == 0) {
                    return this.adapterFactoryLabelProvider.getColumnText(element, columnIndex);
                }
                return "";
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String getColumnTextForElement(Object element, int columnIndex) {
        if (element instanceof RepositoryResource) {
            IRepositoryResource resource = ((RepositoryResource)element).getRepositoryResource();
            IRepositoryResource.Information resourceInfo = resource.getInfo();
            if (columnIndex == 0) {
                return ((RepositoryResource)element).getLabel();
            }
            if (columnIndex == 1) {
                String revision = "";
                try {
                    revision = resource.isInfoCached() ? String.valueOf(((RepositoryResource)element).getRevision()) : ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Model.Pending");
                }
                catch (Exception ex) {
                    LoggedOperation.reportError((String)ModelBusTeamUIPlugin.instance().getResource("Error.GetColumnText"), (Throwable)ex);
                }
                return revision;
            }
            if (resourceInfo != null) {
                if (columnIndex == 2) {
                    return resourceInfo.lastChangedDate != 0L ? DateFormatter.formatDate(resourceInfo.lastChangedDate) : noDate;
                }
                if (columnIndex == 3) {
                    String author = resourceInfo.lastAuthor;
                    return author != null ? author : noAuthor;
                }
                if (columnIndex == 6) {
                    ModelBusLock lock = resourceInfo.lock;
                    String lockOwner = lock == null ? "" : lock.owner;
                    return lockOwner;
                }
                if (columnIndex == 4) {
                    long size = resourceInfo.fileSize;
                    return resource instanceof IRepositoryFile ? String.valueOf(size) : "";
                }
                if (columnIndex == 5) {
                    boolean hasProps = resourceInfo.hasProperties;
                    return hasProps ? RepositoryBrowserLabelProvider.hasProps : "";
                }
            }
        }
        return "";
    }
}

