/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.browser;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.jface.viewers.Viewer;
import org.modelbus.team.eclipse.core.connector.ModelBusLock;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.repository.browser.RepositoryBrowserTableViewer;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryResource;
import org.modelbus.team.eclipse.ui.utility.ColumnedViewerComparator;

public class RepositoryBrowserTableComparator
extends ColumnedViewerComparator {
    public RepositoryBrowserTableComparator(Viewer basedOn) {
        super(basedOn);
    }

    @Override
    public int compareImpl(Viewer viewer, Object row1, Object row2) {
        if (row1 instanceof RepositoryFictiveWorkingDirectory) {
            return -1;
        }
        if (row2 instanceof RepositoryFictiveWorkingDirectory) {
            return 1;
        }
        if (row1 instanceof EObject || row2 instanceof EObject) {
            return 0;
        }
        if (row1 instanceof DelegatingWrapperItemProvider || row2 instanceof DelegatingWrapperItemProvider) {
            return 0;
        }
        IRepositoryResource rowData1 = ((RepositoryResource)row1).getRepositoryResource();
        IRepositoryResource rowData2 = ((RepositoryResource)row2).getRepositoryResource();
        IRepositoryResource.Information info1 = rowData1.getInfo();
        IRepositoryResource.Information info2 = rowData2.getInfo();
        boolean cnd1 = rowData1 instanceof IRepositoryContainer;
        boolean cnd2 = rowData2 instanceof IRepositoryContainer;
        if (cnd1 && !cnd2) {
            return -1;
        }
        if (cnd2 && !cnd1) {
            return 1;
        }
        if (this.column == 0) {
            String name1 = rowData1.getName();
            String name2 = rowData2.getName();
            return ColumnedViewerComparator.compare(name1, name2);
        }
        if (this.column == 1) {
            try {
                ModelBusRevision rev1 = rowData1.getRevision();
                ModelBusRevision rev2 = rowData2.getRevision();
                return rev1.isLowerThan(rev2) ? -1 : (rev1.isGreaterThan(rev2) ? 1 : 0);
            }
            catch (Exception exception) {}
        } else if (info1 != null && info2 != null) {
            if (this.column == 2) {
                long d1 = info1.lastChangedDate;
                long d2 = info2.lastChangedDate;
                return d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
            }
            if (this.column == 3) {
                String author1 = info1.lastAuthor;
                String author2 = info2.lastAuthor;
                author1 = author1 != null ? author1 : RepositoryBrowserTableViewer.noAuthor;
                author2 = author2 != null ? author2 : RepositoryBrowserTableViewer.noAuthor;
                return ColumnedViewerComparator.compare(author1, author2);
            }
            if (this.column == 6) {
                ModelBusLock lock1 = info1.lock;
                ModelBusLock lock2 = info2.lock;
                String lockOwner1 = lock1 == null ? "" : lock1.owner;
                String lockOwner2 = lock2 == null ? "" : lock2.owner;
                return ColumnedViewerComparator.compare(lockOwner1, lockOwner2);
            }
            if (this.column == 5) {
                boolean hasProps1 = info1.hasProperties;
                boolean hasProps2 = info2.hasProperties;
                String c1 = hasProps1 ? RepositoryBrowserTableViewer.hasProps : RepositoryBrowserTableViewer.noProps;
                String c2 = hasProps2 ? RepositoryBrowserTableViewer.hasProps : RepositoryBrowserTableViewer.noProps;
                return ColumnedViewerComparator.compare(c1, c2);
            }
            if (this.column == 4) {
                long s1 = info1.fileSize;
                long s2 = info2.fileSize;
                return s1 < s2 ? -1 : (s1 > s2 ? 1 : 0);
            }
        }
        return 0;
    }
}

