/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.ui.repository.RepositoryTreeViewer;
import org.modelbus.team.eclipse.ui.repository.model.IParentTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.IRepositoryContentFilter;
import org.modelbus.team.eclipse.ui.repository.model.IResourceTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;
import org.modelbus.team.eclipse.ui.repository.preferences.PreferenceInitializer;

public class RepositoryContentProvider
extends WorkbenchContentProvider {
    protected RepositoryTreeViewer repositoryTree;
    protected IRepositoryContentFilter filter;
    protected ComposedAdapterFactory composedAdapterFactory;
    protected AdapterFactoryContentProvider adapterFactoryContentProvider;

    public RepositoryContentProvider(RepositoryTreeViewer repositoryTree) {
        this.repositoryTree = repositoryTree;
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        this.composedAdapterFactory = new ComposedAdapterFactory(factories);
        this.adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.composedAdapterFactory);
    }

    public IRepositoryContentFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IRepositoryContentFilter filter) {
        this.filter = filter;
    }

    private String[] getModelExtensions() {
        String[] modelExtensions = new String[]{};
        modelExtensions = PreferenceInitializer.getExtensionPreference();
        return modelExtensions;
    }

    private boolean isModelToBrowse(String path) {
        List<String> modelExtensions = Arrays.asList(this.getModelExtensions());
        URI uri = URI.createURI((String)path);
        String fileExtension = uri.fileExtension();
        for (String modelExtension : modelExtensions) {
            if (modelExtension.startsWith("*.")) {
                modelExtension = modelExtension.substring(1);
            }
            if (modelExtension.startsWith(".") && path.endsWith(modelExtension)) {
                return true;
            }
            if (!modelExtension.equals(fileExtension)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter instanceof IParentTreeNode) {
            return ((IParentTreeNode)adapter).hasChildren();
        }
        if (adapter instanceof RepositoryFile) {
            String path = ((RepositoryFile)adapter).getRepositoryResource().getUrl();
            if (this.isModelToBrowse(path)) {
                return true;
            }
        } else if (adapter == null) {
            EObject eObject;
            if (element instanceof EObject && (eObject = (EObject)element).eIsProxy()) {
                return true;
            }
            this.adapterFactoryContentProvider.hasChildren(element);
            return this.adapterFactoryContentProvider.hasChildren(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        IWorkbenchAdapter adapter = this.getAdapter(parentElement);
        if (adapter instanceof IParentTreeNode) {
            if (adapter instanceof IResourceTreeNode) {
                ((IResourceTreeNode)adapter).setViewer(this.repositoryTree);
            }
            ArrayList<Object> filtered = new ArrayList<Object>();
            Object[] children = adapter.getChildren(parentElement);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (this.filter == null || this.filter.accept(children[i])) {
                        if (children[i] instanceof IResourceTreeNode) {
                            ((IResourceTreeNode)children[i]).setViewer(this.repositoryTree);
                        }
                        filtered.add(children[i]);
                    }
                    ++i;
                }
            }
            return filtered.toArray();
        }
        if (adapter instanceof RepositoryFile) {
            RepositoryFile modelFile = (RepositoryFile)adapter;
            String resourcePath = modelFile.getRepositoryResource().getUrl();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            HashMap<String, BasicResourceHandler> options = new HashMap<String, BasicResourceHandler>();
            if (resourcePath.endsWith(".emx") || resourcePath.endsWith(".epx")) {
                options.put("RESOURCE_HANDLER", new BasicResourceHandler());
            }
            IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
            try {
                Resource modelResource = resourceSet.createResource(URI.createURI((String)resourcePath));
                try {
                    repositoryHelper.checkOutModel(UserSessionHelper.getSession(), modelResource, options);
                }
                catch (RepositoryAuthentificationException e) {
                    throw new RuntimeException(e);
                }
                catch (UnresolvedReferencesException e) {
                    throw new RuntimeException(e);
                }
                catch (NonExistingResourceException e) {
                    throw new RuntimeException(e);
                }
                EList contents = modelResource.getContents();
                if (contents != null && !contents.isEmpty()) {
                    EObject content = (EObject)contents.get(0);
                    Resource tmp = resourceSet.createResource(URI.createURI((String)resourcePath));
                    tmp.getContents().add((Object)content);
                    return this.adapterFactoryContentProvider.getChildren((Object)tmp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage(), e);
            }
            return new Object[0];
        }
        if (adapter == null && parentElement instanceof EObject) {
            EObject eObject = (EObject)parentElement;
            if (eObject.eIsProxy()) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI proxyURI = ((InternalEObject)eObject).eProxyURI();
                String resourceUri = proxyURI.trimFragment().toString();
                String fragment = proxyURI.fragment();
                HashMap<String, BasicResourceHandler> options = new HashMap<String, BasicResourceHandler>();
                if (resourceUri.endsWith(".emx") || resourceUri.endsWith(".epx")) {
                    options.put("RESOURCE_HANDLER", new BasicResourceHandler());
                }
                Resource resource = resourceSet.createResource(URI.createURI((String)resourceUri));
                IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                try {
                    try {
                        repositoryHelper.checkOutModel(UserSessionHelper.getSession(), resource, options);
                    }
                    catch (RepositoryAuthentificationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (UnresolvedReferencesException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NonExistingResourceException e) {
                        throw new RuntimeException(e);
                    }
                    parentElement = resource.getEObject(fragment);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.adapterFactoryContentProvider.getChildren((Object)((EObject)parentElement));
        }
        if (adapter == null && parentElement instanceof DelegatingWrapperItemProvider) {
            return this.adapterFactoryContentProvider.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent != null) {
            return parent;
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            if (eObject.eContainer() == null) {
                return ModelBusUtility.asRepositoryResource((String)eObject.eResource().getURI().toString(), (boolean)false);
            }
            return this.adapterFactoryContentProvider.getParent((Object)eObject);
        }
        return null;
    }
}

