/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;

public class RepositoryLabelProvider
extends LabelProvider {
    protected ComposedAdapterFactory composedAdapterFactory;
    protected AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    protected WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

    public RepositoryLabelProvider() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        this.composedAdapterFactory = new ComposedAdapterFactory(factories);
        this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    }

    public Image getImage(Object element) {
        if (element instanceof EObject || element instanceof DelegatingWrapperItemProvider) {
            return this.adapterFactoryLabelProvider.getImage(element);
        }
        return this.workbenchLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof EObject) {
            if (((EObject)element).eIsProxy()) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI proxy = ((InternalEObject)element).eProxyURI();
                String fragment = proxy.fragment();
                URI resourceUri = proxy.trimFragment();
                HashMap<String, BasicResourceHandler> options = new HashMap<String, BasicResourceHandler>();
                if (resourceUri.toString().endsWith(".emx") || resourceUri.toString().endsWith(".epx")) {
                    options.put("RESOURCE_HANDLER", new BasicResourceHandler());
                }
                IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                Resource resource = resourceSet.createResource(resourceUri);
                try {
                    try {
                        repositoryHelper.checkOutModel(UserSessionHelper.getSession(), resource, options);
                    }
                    catch (RepositoryAuthentificationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (UnresolvedReferencesException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NonExistingResourceException e) {
                        throw new RuntimeException(e);
                    }
                    element = resource.getEObject(fragment);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.adapterFactoryLabelProvider.getText(element);
        }
        if (element instanceof DelegatingWrapperItemProvider) {
            return this.adapterFactoryLabelProvider.getText(element);
        }
        return this.workbenchLabelProvider.getText(element);
    }
}

