/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;
import org.eclipse.ui.themes.ITheme;
import org.modelbus.team.eclipse.core.connector.ModelBusLock;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.LoggedOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.decorator.DecoratorVariables;
import org.modelbus.team.eclipse.ui.decorator.IVariable;
import org.modelbus.team.eclipse.ui.decorator.IVariableContentProvider;
import org.modelbus.team.eclipse.ui.decorator.UserVariable;
import org.modelbus.team.eclipse.ui.operation.GetRemoteResourceRevisionOperation;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.repository.RepositoriesView;
import org.modelbus.team.eclipse.ui.repository.RepositoryTreeViewer;
import org.modelbus.team.eclipse.ui.repository.model.IResourceTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.IToolTipProvider;
import org.modelbus.team.eclipse.ui.repository.model.ToolTipMessage;
import org.modelbus.team.eclipse.ui.repository.model.ToolTipVariableSetProvider;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;
import org.modelbus.team.eclipse.ui.utility.DefaultOperationWrapperFactory;
import org.modelbus.team.eclipse.ui.utility.OverlayedImageDescriptor;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public abstract class RepositoryResource
implements IWorkbenchAdapter,
IWorkbenchAdapter2,
IAdaptable,
IResourceTreeNode,
IToolTipProvider,
IVariableContentProvider {
    public static RGB NOT_RELATED_NODES_FOREGROUND;
    public static RGB NOT_RELATED_NODES_BACKGROUND;
    public static Font NOT_RELATED_NODES_FONT;
    public static RGB STRUCTURE_DEFINED_NODES_FOREGROUND;
    public static RGB STRUCTURE_DEFINED_NODES_BACKGROUND;
    public static Font STRUCTURE_DEFINED_NODES_FONT;
    protected static Map<ImageDescriptor, OverlayedImageDescriptor> images;
    protected static ImageDescriptor lockDescriptor;
    protected static ImageDescriptor externalsDescriptor;
    protected GetRemoteResourceRevisionOperation revisionOp;
    protected IRepositoryResource resource;
    protected RepositoryResource parent;
    protected RepositoryTreeViewer repositoryTree;
    protected Boolean relatesToLocation;
    protected IPropertyChangeListener configurationListener;
    protected DecoratorVariables toolTipDecorator;
    protected String label;
    protected boolean externals;

    static {
        images = new HashMap<ImageDescriptor, OverlayedImageDescriptor>();
    }

    public RepositoryResource(RepositoryResource parent, IRepositoryResource resource) {
        this.parent = parent;
        this.resource = resource;
        if (NOT_RELATED_NODES_FOREGROUND == null) {
            this.initializeFontsAndColors();
        }
        this.toolTipDecorator = new DecoratorVariables(ToolTipVariableSetProvider.instance);
    }

    public boolean isExternals() {
        return this.externals ? true : (this.parent == null ? false : this.parent.isExternals());
    }

    public void setExternals(boolean externals) {
        this.externals = externals;
    }

    public RepositoryResource getParent() {
        return this.parent;
    }

    public boolean isRelatesToLocation() {
        if (this.relatesToLocation == null) {
            this.relatesToLocation = Boolean.TRUE;
        }
        return this.relatesToLocation;
    }

    @Override
    public void setViewer(RepositoryTreeViewer repositoryTree) {
        this.repositoryTree = repositoryTree;
    }

    @Override
    public IRepositoryResource getRepositoryResource() {
        return this.resource;
    }

    @Override
    public Object getData() {
        return this.resource;
    }

    @Override
    public void refresh() {
        this.resource.refresh();
        this.revisionOp = null;
    }

    public RGB getBackground(Object element) {
        return this.isRelatesToLocation() ? null : NOT_RELATED_NODES_BACKGROUND;
    }

    public RGB getForeground(Object element) {
        return this.isRelatesToLocation() ? null : NOT_RELATED_NODES_FOREGROUND;
    }

    public FontData getFont(Object element) {
        return this.isRelatesToLocation() ? null : NOT_RELATED_NODES_FONT.getFontData()[0];
    }

    public String getLabel(Object o) {
        String retVal = String.valueOf(this.getLabel()) + " ";
        try {
            retVal = String.valueOf(retVal) + this.getRevision();
        }
        catch (Exception e) {
            LoggedOperation.reportError((String)ModelBusTeamUIPlugin.instance().getResource("Error.FormatLabel"), (Throwable)e);
            retVal = String.valueOf(retVal) + ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Model.Error");
        }
        return retVal;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        ImageDescriptor originalDescriptor = this.getImageDescriptorImpl();
        IRepositoryResource.Information info = this.resource.getInfo();
        if (info != null && info.lock != null) {
            if (lockDescriptor == null) {
                lockDescriptor = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/lock.gif");
            }
            return RepositoryResource.decorateImage(originalDescriptor, lockDescriptor);
        }
        if (this.isExternals() && ModelBusTeamPreferences.getDecorationBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "icon.switched")) {
            if (externalsDescriptor == null) {
                externalsDescriptor = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/switched.gif");
            }
            return RepositoryResource.decorateImage(originalDescriptor, externalsDescriptor);
        }
        return originalDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ImageDescriptor decorateImage(ImageDescriptor originalDescriptor, ImageDescriptor decorationDescriptor) {
        Map<ImageDescriptor, OverlayedImageDescriptor> map = images;
        synchronized (map) {
            OverlayedImageDescriptor imgDescr = images.get(originalDescriptor);
            if (imgDescr == null) {
                Image image = originalDescriptor.createImage();
                CompareUI.disposeOnShutdown((Image)image);
                imgDescr = new OverlayedImageDescriptor(image, decorationDescriptor, new Point(16, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.BOTTOM);
                images.put(originalDescriptor, imgDescr);
            }
            return imgDescr;
        }
    }

    public Object getParent(Object o) {
        return this.resource.getParent();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IWorkbenchAdapter.class) || adapter.equals(IWorkbenchAdapter2.class)) {
            return this;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RepositoryResource) {
            return ((RepositoryResource)obj).resource.equals(this.resource);
        }
        return super.equals(obj);
    }

    @Override
    public String getToolTipMessage(String formatString) {
        ToolTipMessage tooltipMessage = new ToolTipMessage();
        IVariable[] format = this.toolTipDecorator.parseFormatLine(formatString);
        this.toolTipDecorator.decorateText(tooltipMessage, format, this);
        return tooltipMessage.getMessage();
    }

    @Override
    public String getValue(IVariable var) {
        ModelBusLock lock;
        IRepositoryResource resource = this.getRepositoryResource();
        IRepositoryResource.Information info = resource.getInfo();
        ModelBusLock modelBusLock = lock = info == null ? null : info.lock;
        if (var.equals(ToolTipVariableSetProvider.VAR_NAME)) {
            return this.formatToolTipLine(var, resource.getName());
        }
        if (var.equals(ToolTipVariableSetProvider.VAR_URL)) {
            return this.formatToolTipLine(var, resource.getUrl());
        }
        if (var.equals(ToolTipVariableSetProvider.VAR_LAST_CHANGE_DATE)) {
            if (info != null && info.lastChangedDate != 0L) {
                return this.formatToolTipLine(var, DateFormatter.formatDate(info.lastChangedDate));
            }
        } else if (var.equals(ToolTipVariableSetProvider.VAR_LAST_AUTHOR)) {
            if (info != null && info.lastAuthor != null && !info.lastAuthor.equals("")) {
                return this.formatToolTipLine(var, info.lastAuthor);
            }
        } else if (var.equals(ToolTipVariableSetProvider.VAR_SIZE)) {
            if (info != null) {
                return this.formatToolTipLine(var, String.valueOf(info.fileSize));
            }
        } else if (var.equals(ToolTipVariableSetProvider.VAR_LOCK_OWNER)) {
            if (lock != null && lock.owner != null) {
                return this.formatToolTipLine(var, lock.owner);
            }
        } else if (var.equals(ToolTipVariableSetProvider.VAR_LOCK_CREATION_DATE)) {
            if (lock != null && lock.creationDate != 0L) {
                return this.formatToolTipLine(var, DateFormatter.formatDate(lock.creationDate));
            }
        } else if (var.equals(ToolTipVariableSetProvider.VAR_LOCK_EXPIRATION_DATE)) {
            if (lock != null && lock.expirationDate != 0L) {
                return this.formatToolTipLine(var, DateFormatter.formatDate(lock.expirationDate));
            }
        } else if (var.equals(ToolTipVariableSetProvider.VAR_LOCK_COMMENT) && lock != null && lock.comment != null && lock.comment.length() != 0) {
            return this.formatToolTipLine(var, lock.comment);
        }
        if (var instanceof UserVariable) {
            return var.toString();
        }
        return "";
    }

    protected String formatToolTipLine(IVariable var, String value) {
        return String.valueOf(var.getDescription()) + " " + value + "\n";
    }

    protected void initializeFontsAndColors() {
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.decoration.")) {
                    RepositoryResource.loadConfiguration();
                    RepositoriesView repositoriesView = RepositoriesView.instance();
                    if (repositoriesView != null) {
                        repositoriesView.getRepositoryTree().refresh();
                    }
                }
            }
        };
        RepositoryResource.loadConfiguration();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener(this.configurationListener);
    }

    protected static void loadConfiguration() {
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                NOT_RELATED_NODES_FOREGROUND = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("not_related_nodes_foreground_color")).getRGB();
                NOT_RELATED_NODES_BACKGROUND = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("not_related_nodes_background_color")).getRGB();
                NOT_RELATED_NODES_FONT = current.getFontRegistry().get(ModelBusTeamPreferences.fullDecorationName("not_related_nodes_font"));
                STRUCTURE_DEFINED_NODES_FOREGROUND = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("structure_nodes_foreground_color")).getRGB();
                STRUCTURE_DEFINED_NODES_BACKGROUND = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("structure_nodes_background_color")).getRGB();
                STRUCTURE_DEFINED_NODES_FONT = current.getFontRegistry().get(ModelBusTeamPreferences.fullDecorationName("structure_nodes_font"));
            }
        });
    }

    public String getLabel() {
        return this.label == null ? this.resource.getName() : this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRevision() throws Exception {
        if (this.revisionOp != null) {
            return this.revisionOp.getRevision() == "-1" ? ModelBusTeamUIPlugin.instance().getResource(this.revisionOp.getExecutionState() == 1 ? "RepositoriesView.Model.Error" : "RepositoriesView.Model.Pending") : String.valueOf(this.revisionOp.getRevision());
        }
        if (this.resource.isInfoCached()) {
            return String.valueOf(this.resource.getRevision());
        }
        this.revisionOp = new GetRemoteResourceRevisionOperation(this.resource);
        CompositeOperation op = new CompositeOperation(this.revisionOp.getId());
        op.add((IActionOperation)this.revisionOp);
        op.add((IActionOperation)this.getRefreshOperation(this.getViewer()));
        UIMonitorUtility.doTaskScheduled((IActionOperation)op, new DefaultOperationWrapperFactory(){

            @Override
            public IActionOperation getLogged(IActionOperation operation) {
                return new LoggedOperation(operation);
            }
        });
        return ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Model.Pending");
    }

    protected RepositoryTreeViewer getViewer() {
        return this.repositoryTree;
    }

    protected RefreshOperation getRefreshOperation(RepositoryTreeViewer viewer) {
        return new RefreshOperation(viewer);
    }

    protected abstract ImageDescriptor getImageDescriptorImpl();

    protected class RefreshOperation
    extends AbstractActionOperation {
        protected RepositoryTreeViewer viewer;

        public RefreshOperation(RepositoryTreeViewer viewer) {
            super("Operation.RefreshView");
            this.viewer = viewer;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.refresh(RepositoryResource.this, null, true);
            }
        }
    }
}

