/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.repository.model;

import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.repository.model.IDataTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.IParentTreeNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFictiveNode;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFolder;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryResource;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryRevisions;

public class RepositoryRevision
extends RepositoryFictiveNode
implements IParentTreeNode,
IDataTreeNode {
    protected static String REVISION_NAME;
    protected IRepositoryResource[] resources;
    protected RepositoryResource[] wrappers;
    protected RepositoryRevisions parent;
    protected ModelBusRevision revision;

    public RepositoryRevision(RepositoryRevisions parent, ModelBusRevision revision) {
        REVISION_NAME = ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Model.Revision");
        this.parent = parent;
        this.revision = revision;
        this.refresh();
    }

    @Override
    public RGB getForeground(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_FOREGROUND;
    }

    @Override
    public RGB getBackground(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_BACKGROUND;
    }

    @Override
    public FontData getFont(Object element) {
        return RepositoryResource.NOT_RELATED_NODES_FONT.getFontData()[0];
    }

    public IRepositoryResource[] getRepositoryResources() {
        return this.resources;
    }

    @Override
    public void refresh() {
        this.resources = this.parent.getLinks(this.revision);
        this.wrappers = RepositoryFolder.wrapChildren(null, this.resources, null);
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public String getLabel(Object o) {
        return MessageFormat.format(REVISION_NAME, this.revision.toString());
    }

    public Object[] getChildren(Object o) {
        return this.wrappers;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RepositoryRevision) {
            RepositoryRevision other = (RepositoryRevision)obj;
            return this.parent.equals(other.parent) && this.revision.equals((Object)other.revision);
        }
        return super.equals(obj);
    }
}

