/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.status;

import org.modelbus.core.lib.IServicesHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.types.Status;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.status.ModelBusStatusProvider;

public class ModelBusRepositoryPing
extends Thread {
    private long interval;
    private boolean stop = false;
    private IServicesHelper servicesHelper = null;

    public ModelBusRepositoryPing(long interval) {
        if (interval < 0L) {
            throw new IllegalArgumentException("Value for ping interval has to be non negative.");
        }
        this.interval = interval;
    }

    @Override
    public void run() {
        ModelBusStatusProvider statusProvider = ModelBusTeamUIPlugin.instance().getStatus();
        while (!this.stop) {
            try {
                if (this.servicesHelper == null) {
                    this.servicesHelper = ModelBusCoreLib.getServicesHelper();
                }
                Status status = this.servicesHelper.getStatus(UserSessionHelper.getSession(), true);
                statusProvider.setStatus(status);
            }
            catch (RepositoryAuthentificationException e) {
                statusProvider.registerException((Exception)((Object)e));
                statusProvider.setAvailable(false);
            }
            catch (Exception exception) {
                statusProvider.setAvailable(false);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public void kill() {
        this.stop = true;
    }
}

