/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.status;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.status.ModelBusStatusProvider;

public class ModelBusStatusLineContributionItem
extends ContributionItem
implements Observer {
    private static final String AV_ICON_PATH = "/icons/status/modelbus_av.gif";
    private static final String UNAV_ICON_PATH = "/icons/status/modelbus_unav.gif";
    private static final String AV_LABEL = "ModelBus available";
    private static final String UNAV_LABEL = "ModelBus unavailable";
    private Image statusImage;
    private Composite parent;
    private Canvas canvas;

    public ModelBusStatusLineContributionItem(String id) {
        super(id);
    }

    public void fill(Composite parent) {
        this.parent = parent;
        Composite canvasComposite = new Composite(this.parent, 0);
        canvasComposite.setLayout((Layout)new GridLayout(1, false));
        this.canvas = new Canvas(canvasComposite, 0);
        this.canvas.setLayoutData((Object)new GridData(32, 16));
        this.statusImage = ModelBusTeamUIPlugin.instance().getImageDescriptor(UNAV_ICON_PATH).createImage();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ModelBusStatusLineContributionItem.this.statusImage != null && !ModelBusStatusLineContributionItem.this.statusImage.isDisposed()) {
                    e.gc.drawImage(ModelBusStatusLineContributionItem.this.statusImage, 0, 0);
                    ModelBusStatusLineContributionItem.this.statusImage.dispose();
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.modelbus.team.eclipse.ui.status.StatusView");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.canvas.setToolTipText(UNAV_LABEL);
        this.updateControls();
    }

    private void updateControls() {
        if (this.parent == null) {
            return;
        }
        this.parent.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ModelBusStatusLineContributionItem.this.canvas.isDisposed()) {
                    return;
                }
                if (ModelBusTeamUIPlugin.instance().getStatus().isAvailable()) {
                    ModelBusStatusLineContributionItem.this.statusImage = ModelBusTeamUIPlugin.instance().getImageDescriptor(ModelBusStatusLineContributionItem.AV_ICON_PATH).createImage();
                    ModelBusStatusLineContributionItem.this.canvas.setToolTipText("ModelBus available (Last response: " + ModelBusStatusProvider.DATE_FORMAT.format(ModelBusTeamUIPlugin.instance().getStatus().getLastResponse()) + ")");
                } else {
                    ModelBusStatusLineContributionItem.this.statusImage = ModelBusTeamUIPlugin.instance().getImageDescriptor(ModelBusStatusLineContributionItem.UNAV_ICON_PATH).createImage();
                    ModelBusStatusLineContributionItem.this.canvas.setToolTipText(ModelBusTeamUIPlugin.instance().getStatus().getStatusMessage());
                }
                ModelBusStatusLineContributionItem.this.canvas.redraw();
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateControls();
    }
}

