/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize;

import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.resource.ILocalFolder;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.ui.synchronize.variant.BaseFileVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.BaseFolderVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.RemoteFileVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.RemoteFolderVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.VirtualRemoteFileVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.VirtualRemoteFolderVariant;

public abstract class AbstractModelBusSyncInfo
extends SyncInfo {
    protected ILocalResource local;

    public AbstractModelBusSyncInfo(ILocalResource local, IResourceChange remote, IResourceVariantComparator comparator) {
        this(local, AbstractModelBusSyncInfo.makeBaseVariant(local), AbstractModelBusSyncInfo.makeRemoteVariant(local, (ILocalResource)remote), comparator);
    }

    protected AbstractModelBusSyncInfo(ILocalResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator) {
        super(local.getResource(), base, remote, comparator);
        this.local = local;
    }

    public ILocalResource getLocalResource() {
        return this.local;
    }

    protected boolean isLinked(String kind, int mask) {
        return IStateFilter.SF_LINKED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isReplaced(String kind, int mask) {
        return IStateFilter.SF_PREREPLACEDREPLACED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isDeleted(String kind, int mask) {
        return IStateFilter.SF_DELETED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isModified(String kind, int mask) {
        return IStateFilter.SF_MODIFIED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isConflicted(String kind, int mask) {
        return IStateFilter.SF_CONFLICTING.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNotModified(String kind, int mask) {
        return IStateFilter.SF_NOTMODIFIED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNonVersioned(String kind, int mask) {
        return IStateFilter.SF_UNVERSIONED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNotExists(String kind, int mask) {
        return IStateFilter.SF_NOTEXISTS.accept(this.getLocal(), kind, mask);
    }

    protected boolean isIgnored(String kind, int mask) {
        return IStateFilter.SF_IGNORED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isAdded(String kind, int mask) {
        return IStateFilter.SF_ADDED.accept(this.getLocal(), kind, mask);
    }

    protected static IResourceVariant makeBaseVariant(ILocalResource local) {
        if (local == null) {
            return null;
        }
        return local instanceof ILocalFolder ? new BaseFolderVariant(local) : new BaseFileVariant(local);
    }

    protected static IResourceVariant makeRemoteVariant(ILocalResource local, ILocalResource remote) {
        if (remote == null) {
            return local instanceof ILocalFolder ? new VirtualRemoteFolderVariant(local) : new VirtualRemoteFileVariant(local);
        }
        return remote instanceof ILocalFolder ? new RemoteFolderVariant(remote) : new RemoteFileVariant(remote);
    }
}

