/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusChangeStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryStatus;
import org.modelbus.team.eclipse.core.extension.CoreExtensionsManager;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.LoggedOperation;
import org.modelbus.team.eclipse.core.operation.local.IRemoteStatusOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.resource.events.IResourceStatesListener;
import org.modelbus.team.eclipse.core.resource.events.ResourceStatesChangedEvent;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ILoggedOperationFactory;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.synchronize.RemoteStatusCache;
import org.modelbus.team.eclipse.ui.synchronize.ResourceVariantComparator;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public abstract class AbstractModelbusSubscriber
extends Subscriber
implements IResourceStatesListener {
    protected static final IResourceVariantComparator RV_COMPARATOR = new ResourceVariantComparator();
    protected RemoteStatusCache statusCache = new RemoteStatusCache();
    protected Set<IResource> oldResources;

    public AbstractModelbusSubscriber() {
        ModelBusRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
        this.oldResources = new HashSet<IResource>();
    }

    public boolean isSynchronizedWithRepository() {
        return this.statusCache.containsData();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isSupervised(IResource resource) {
        return FileUtility.isConnected((IResource)resource) && !FileUtility.isModelBusInternals((IResource)resource) && !FileUtility.isLinked((IResource)resource);
    }

    public IResource[] members(IResource resource) {
        ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(resource);
        if (IStateFilter.SF_INTERNAL_INVALID.accept(local) || IStateFilter.SF_IGNORED.accept(local) || IStateFilter.SF_NOTEXISTS.accept(local)) {
            return FileUtility.NO_CHILDREN;
        }
        return this.statusCache.allMembers(resource);
    }

    public IResource[] roots() {
        ArrayList<IProject> roots = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (FileUtility.isConnected((IResource)projects[i])) {
                roots.add(projects[i]);
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        ILocalResource localStatus;
        if (!this.isSupervised(resource)) {
            return null;
        }
        IResourceChange remoteStatus = ModelBusRemoteStorage.instance().resourceChangeFromBytes(this.statusCache.getBytes(resource));
        ILocalResource iLocalResource = localStatus = this.statusCache.containsData() ? ModelBusRemoteStorage.instance().asLocalResourceDirty(resource) : ModelBusRemoteStorage.instance().asLocalResource(resource);
        if (!IStateFilter.SF_INTERNAL_INVALID.accept(localStatus) || remoteStatus != null) {
            SyncInfo info = this.getModelBusSyncInfo(localStatus, remoteStatus);
            if (info != null) {
                info.init();
                int kind = info.getKind();
                if (SyncInfo.getChange((int)kind) == 2 && (SyncInfo.getDirection((int)kind) & 4) != 0 && !resource.exists()) {
                    Set<IResource> set = this.oldResources;
                    synchronized (set) {
                        this.oldResources.add(resource);
                    }
                }
            }
            return info;
        }
        return null;
    }

    public IResourceVariantComparator getResourceComparator() {
        return RV_COMPARATOR;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) {
        ArrayList<IResource> resourcesToOperateList = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            if (FileUtility.isConnected((IResource)current)) {
                resourcesToOperateList.add(current);
            }
            ++n2;
        }
        IResource[] operableData = resourcesToOperateList.toArray(new IResource[0]);
        HashSet<IResource> refreshScope = this.clearRemoteStatusesImpl(operableData);
        this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        if (ModelBusTeamPreferences.getSynchronizeBoolean(store, "fastReport")) {
            UpdateStatusOperation op = new UpdateStatusOperation(operableData, depth);
            ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
        } else {
            this.resourcesStateChangedImpl(this.findChanges(operableData, depth, monitor, UIMonitorUtility.DEFAULT_FACTORY));
        }
    }

    public void clearRemoteStatuses(IResource[] resources) {
        HashSet<IResource> refreshScope = this.clearRemoteStatusesImpl(resources);
        this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        if (event.type == 0) {
            this.resourcesStateChangedImpl(event.getResourcesRecursivelly());
        }
    }

    protected HashSet<IResource> clearRemoteStatusesImpl(IResource[] resources) {
        return this.clearRemoteStatusesImpl(this.statusCache, resources);
    }

    protected HashSet<IResource> clearRemoteStatusesImpl(RemoteStatusCache cache, IResource[] resources) {
        final HashSet<IResource> refreshSet = new HashSet<IResource>();
        cache.traverse(resources, 2, new RemoteStatusCache.ICacheVisitor(){

            @Override
            public void visit(IPath current, byte[] data) {
                IResource resource = ModelBusRemoteStorage.instance().resourceChangeFromBytes(data).getResource();
                if (resource != null) {
                    refreshSet.add(resource);
                }
            }
        });
        int i = 0;
        while (i < resources.length) {
            cache.flushBytes(resources[i], 2);
            ++i;
        }
        return refreshSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resourcesStateChangedImpl(IResource[] resources) {
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            allResources.addAll(Arrays.asList(this.statusCache.allMembers(resources[i])));
            ++i;
        }
        Set<IResource> set = this.oldResources;
        synchronized (set) {
            for (IResource resource : this.oldResources) {
                ModelBusChangeStatus status = ModelBusUtility.getModelBusInfoForNotConnected((IResource)resource);
                if (status != null && (status.textStatus == 4 || status.textStatus == 6)) continue;
                allResources.add(resource);
            }
            IResource[] refreshSet = allResources.toArray(new IResource[allResources.size()]);
            if (CoreExtensionsManager.instance().getOptionProvider().isModelBusCacheEnabled()) {
                IResource[] parents = FileUtility.getParents((IResource[])refreshSet, (boolean)false);
                int i2 = 0;
                while (i2 < parents.length) {
                    try {
                        ModelBusRemoteStorage.instance().getRegisteredChildren((IContainer)parents[i2]);
                    }
                    catch (Exception ex) {
                        LoggedOperation.reportError((String)ModelBusTeamUIPlugin.instance().getResource("Error.CheckCache"), (Throwable)ex);
                    }
                    ++i2;
                }
            }
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])refreshSet));
        }
    }

    protected IResource[] findChanges(IResource[] resources, int depth, IProgressMonitor monitor, ILoggedOperationFactory operationWrapperFactory) {
        CompositeOperation op = new CompositeOperation("");
        final IRemoteStatusOperation rStatusOp = this.addStatusOperation(op, resources, depth);
        if (rStatusOp == null) {
            return FileUtility.NO_CHILDREN;
        }
        op.setOperationName(rStatusOp.getId());
        final ArrayList changes = new ArrayList();
        op.add((IActionOperation)new AbstractActionOperation("Operation.FetchChanges"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ModelBusEntryStatus[] statuses = rStatusOp.getStatuses();
                if (statuses != null) {
                    int i = 0;
                    while (i < statuses.length && !monitor.isCanceled()) {
                        IResourceChange resourceChange;
                        if (AbstractModelbusSubscriber.this.isIncoming(statuses[i]) && (resourceChange = AbstractModelbusSubscriber.this.handleResourceChange(rStatusOp, statuses[i])) != null) {
                            ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)String.valueOf(resourceChange.getRevision()));
                            AbstractModelbusSubscriber.this.statusCache.setBytes(resourceChange.getResource(), ModelBusRemoteStorage.instance().resourceChangeAsBytes(resourceChange));
                            changes.add(resourceChange.getResource());
                        }
                        ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)statuses.length);
                        ++i;
                    }
                }
            }
        }, new IActionOperation[]{rStatusOp});
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor, (ILoggedOperationFactory)operationWrapperFactory);
        return changes.toArray(new IResource[changes.size()]);
    }

    protected abstract boolean isIncoming(ModelBusEntryStatus var1);

    protected abstract IResourceChange handleResourceChange(IRemoteStatusOperation var1, ModelBusEntryStatus var2);

    protected abstract SyncInfo getModelBusSyncInfo(ILocalResource var1, IResourceChange var2);

    protected abstract IRemoteStatusOperation addStatusOperation(CompositeOperation var1, IResource[] var2, int var3);

    public class UpdateStatusOperation
    extends AbstractActionOperation
    implements ILoggedOperationFactory {
        protected IResource[] resources;
        protected int depth;

        public UpdateStatusOperation(IResource[] resources, int depth) {
            super("Operation.UpdateStatus");
            this.resources = resources;
            this.depth = depth;
        }

        public IActionOperation getLogged(IActionOperation operation) {
            return new LoggedOperation(operation){

                protected void handleError(IStatus errorStatus) {
                    UpdateStatusOperation.this.reportStatus(errorStatus);
                }
            };
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            Map project2Resources = ModelBusUtility.splitWorkingCopies((IResource[])this.resources);
            Iterator it = project2Resources.values().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                List entry = (List)it.next();
                final IResource[] wcResources = entry.toArray(new IResource[entry.size()]);
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        AbstractModelbusSubscriber.this.resourcesStateChangedImpl(AbstractModelbusSubscriber.this.findChanges(wcResources, UpdateStatusOperation.this.depth, monitor, UpdateStatusOperation.this));
                    }
                }, monitor, project2Resources.size());
            }
        }
    }
}

