/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.synchronize.ModelBusChangeSetCapability;
import org.modelbus.team.eclipse.ui.synchronize.variant.ResourceVariant;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;

public class ModelBusChangeSetCollector
extends SyncInfoSetChangeSetCollector {
    public ModelBusChangeSetCollector(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    public void dispose() {
        ModelBusChangeSetCapability.isEnabled = false;
        super.dispose();
    }

    protected void add(SyncInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return;
        }
        HashMap<String, ModelBusCheckedInChangeSet> sets = new HashMap<String, ModelBusCheckedInChangeSet>();
        final HashSet<ModelBusCheckedInChangeSet> added = new HashSet<ModelBusCheckedInChangeSet>();
        ChangeSet[] changeSetArray = this.getSets();
        int n = changeSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            ModelBusCheckedInChangeSet modelbusSet = (ModelBusCheckedInChangeSet)set;
            sets.put(modelbusSet.getRevision().getRevision(), modelbusSet);
            ++n2;
        }
        String modelbusAuthor = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.Author");
        String modelbusDate = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.Date");
        String modelbusNoAuthor = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoAuthor");
        String modelbusNoDate = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoDate");
        SyncInfo[] syncInfoArray = infos;
        int n3 = infos.length;
        int n4 = 0;
        while (n4 < n3) {
            SyncInfo info = syncInfoArray[n4];
            if ((info.getKind() & 8) != 0) {
                ResourceVariant remote = (ResourceVariant)info.getRemote();
                ILocalResource resource = remote.getResource();
                ModelBusRevision revision = resource.getRevision();
                ModelBusCheckedInChangeSet set = (ModelBusCheckedInChangeSet)((Object)sets.get(revision));
                boolean updateName = false;
                if (set == null) {
                    set = new ModelBusCheckedInChangeSet();
                    set.author = resource.getAuthor();
                    set.date = new Date(resource.getLastCommitDate());
                    set.revision = revision;
                    if (resource instanceof IResourceChange) {
                        set.comment = ((IResourceChange)resource).getComment();
                    }
                    updateName = true;
                    sets.put(revision.getRevision(), set);
                    added.add(set);
                } else if (set.date.getTime() == 0L) {
                    updateName = true;
                    set.date = new Date(resource.getLastCommitDate());
                } else if (set.author == null) {
                    updateName = true;
                    set.author = resource.getAuthor();
                }
                if (updateName) {
                    String name = String.valueOf(String.valueOf(revision)) + " " + (resource.getLastCommitDate() == 0L ? modelbusNoDate : MessageFormat.format(modelbusDate, DateFormatter.formatDate(set.date))) + " " + (resource.getAuthor() == null ? modelbusNoAuthor : MessageFormat.format(modelbusAuthor, resource.getAuthor()));
                    if (set.comment != null) {
                        String comment = set.comment;
                        if (FileUtility.isWindows()) {
                            comment = comment.replaceAll("\r\n|\r|\n", " ");
                        }
                        name = String.valueOf(name) + " " + comment;
                    }
                    set.setName(name);
                }
                set.add(info);
            }
            ++n4;
        }
        this.performUpdate(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (ModelBusCheckedInChangeSet set : added) {
                    ModelBusChangeSetCollector.this.add((ChangeSet)set);
                }
            }
        }, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initializeSets() {
    }

    public static class ModelBusCheckedInChangeSet
    extends CheckedInChangeSet {
        private String author;
        private String comment;
        private Date date;
        private ModelBusRevision revision;

        public ModelBusRevision getRevision() {
            return this.revision;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getComment() {
            return this.comment;
        }

        public void setName(String name) {
            super.setName(name);
        }
    }
}

