/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.action;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.compare.ThreeWayPropertyCompareInput;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.variant.RemoteResourceVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.ResourceVariant;

public class ComparePropertiesAction
extends AbstractSynchronizeModelAction {
    public ComparePropertiesAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ISynchronizeModelElement element;
        super.updateSelection(selection);
        if (selection.size() == 1 && selection.getFirstElement() instanceof SyncInfoModelElement && (element = (ISynchronizeModelElement)selection.getFirstElement()) instanceof SyncInfoModelElement) {
            AbstractModelBusSyncInfo syncInfo = (AbstractModelBusSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo();
            ILocalResource incoming = ((ResourceVariant)syncInfo.getRemote()).getResource();
            boolean retVal = IStateFilter.SF_EXCLUDE_DELETED.accept(incoming);
            if (incoming instanceof IResourceChange) {
                retVal &= "Deleted" != incoming.getStatus();
            }
            return retVal && ((incoming.getChangeMask() & 2) != 0 || (syncInfo.getLocalResource().getChangeMask() & 2) != 0 || incoming.getResource() instanceof IContainer);
        }
        return false;
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        ModelBusEntryRevisionReference baseReference;
        IResource resource = this.getSelectedResource();
        ILocalResource baseResource = ModelBusRemoteStorage.instance().asLocalResource(resource);
        IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(resource);
        ModelBusEntryRevisionReference remoteReference = baseReference = new ModelBusEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)resource), null, ModelBusRevision.BASE);
        ILocalResource change = ((RemoteResourceVariant)this.getSelectedModelBusSyncInfo().getRemote()).getResource();
        if (change instanceof IResourceChange) {
            remote = ((IResourceChange)change).getOriginator();
            remoteReference = new ModelBusEntryRevisionReference(remote.getUrl(), remote.getPegRevision(), ((IResourceChange)change).getRevision());
        }
        ThreeWayPropertyCompareInput input = new ThreeWayPropertyCompareInput(new CompareConfiguration(), resource, remoteReference, baseReference, baseResource.getRevision().getRevision());
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }
}

