/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.FiniExtractLogOperation;
import org.modelbus.team.eclipse.core.operation.local.InitExtractLogOperation;
import org.modelbus.team.eclipse.core.operation.remote.ExtractToOperationRemote;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.action.ISyncStateFilter;
import org.modelbus.team.eclipse.ui.synchronize.variant.RemoteResourceVariant;

public class ExtractIncomingToAction
extends AbstractSynchronizeModelAction {
    public ExtractIncomingToAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12});
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        DirectoryDialog fileDialog = new DirectoryDialog(configuration.getSite().getShell());
        fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ExtractToAction.Select.Title"));
        fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ExtractToAction.Select.Description"));
        String path = fileDialog.open();
        if (path == null) {
            return null;
        }
        IResource[] incomingChanges = this.syncInfoSelector.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ALL, true));
        HashSet<IResource> incomingWithProjects = new HashSet<IResource>(Arrays.asList(incomingChanges));
        IResource[] iResourceArray = incomingChanges;
        int n = incomingChanges.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            incomingWithProjects.add((IResource)current.getProject());
            ++n2;
        }
        incomingChanges = incomingWithProjects.toArray(new IResource[incomingWithProjects.size()]);
        HashSet<IResource> deletionsOnly = new HashSet<IResource>(Arrays.asList(this.syncInfoSelector.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(null, IStateFilter.SF_DELETED, false))));
        HashSet<IRepositoryResource> incomingResourcesToOperate = new HashSet<IRepositoryResource>();
        HashSet<String> markedForDelition = new HashSet<String>();
        HashMap<String, String> resource2project = new HashMap<String, String>();
        HashMap<String, String> url2status = new HashMap<String, String>();
        IResource[] iResourceArray2 = incomingChanges;
        int n3 = incomingChanges.length;
        int n4 = 0;
        while (n4 < n3) {
            AbstractModelBusSyncInfo[] syncInfos;
            IResource current = iResourceArray2[n4];
            IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(current);
            IRepositoryResource projectRemote = ModelBusRemoteStorage.instance().asRepositoryResource((IResource)current.getProject());
            if (current instanceof IProject) {
                resource2project.put(remote.getUrl(), current.getName());
            } else if (!new Path(projectRemote.getUrl()).isPrefixOf((IPath)new Path(remote.getUrl()))) {
                resource2project.put(remote.getUrl(), current.getFullPath().toString().substring(1));
            }
            incomingResourcesToOperate.add(remote);
            AbstractModelBusSyncInfo[] abstractModelBusSyncInfoArray = syncInfos = this.getModelBusSyncInfos();
            int n5 = syncInfos.length;
            int n6 = 0;
            while (n6 < n5) {
                AbstractModelBusSyncInfo info = abstractModelBusSyncInfoArray[n6];
                if (SyncInfo.getDirection((int)info.getKind()) == 8) {
                    IResourceChange change = (IResourceChange)((RemoteResourceVariant)info.getRemote()).getResource();
                    if (remote.getUrl().equals(change.getOriginator().getUrl())) {
                        url2status.put(remote.getUrl(), change.getStatus());
                    }
                }
                ++n6;
            }
            if (deletionsOnly.contains(current)) {
                markedForDelition.add(remote.getUrl());
            }
            ++n4;
        }
        InitExtractLogOperation logger = new InitExtractLogOperation(path);
        ExtractToOperationRemote mainOp = new ExtractToOperationRemote(incomingResourcesToOperate.toArray(new IRepositoryResource[incomingResourcesToOperate.size()]), url2status, markedForDelition, path, resource2project, logger, true);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)logger);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new FiniExtractLogOperation(logger));
        return op;
    }
}

