/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.action;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.ui.compare.ThreeWayPropertyCompareInput;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.variant.ResourceVariant;

public class MergePropertiesAction
extends AbstractSynchronizeModelAction {
    public MergePropertiesAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ISynchronizeModelElement element;
        super.updateSelection(selection);
        if (selection.size() == 1 && selection.getFirstElement() instanceof SyncInfoModelElement && (element = (ISynchronizeModelElement)selection.getFirstElement()) instanceof SyncInfoModelElement) {
            AbstractModelBusSyncInfo syncInfo = (AbstractModelBusSyncInfo)((SyncInfoModelElement)selection.getFirstElement()).getSyncInfo();
            ILocalResource incoming = ((ResourceVariant)syncInfo.getRemote()).getResource();
            if (!(incoming instanceof IResourceChange)) {
                return false;
            }
            boolean retVal = IStateFilter.SF_EXCLUDE_DELETED.accept(incoming);
            if (incoming instanceof IResourceChange) {
                retVal &= "Deleted" != incoming.getStatus();
            }
            return retVal && ((incoming.getChangeMask() & 2) != 0 || (syncInfo.getLocalResource().getChangeMask() & 2) != 0);
        }
        return false;
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource resource = this.getSelectedResource();
        AbstractModelBusSyncInfo syncInfo = (AbstractModelBusSyncInfo)((SyncInfoModelElement)elements[0]).getSyncInfo();
        IResourceChange right = (IResourceChange)((ResourceVariant)syncInfo.getRemote()).getResource();
        IResourceChange ancestor = (IResourceChange)((ResourceVariant)syncInfo.getBase()).getResource();
        ModelBusEntryRevisionReference baseReference = new ModelBusEntryRevisionReference(ancestor.getOriginator().getUrl(), ancestor.getPegRevision(), ancestor.getRevision());
        ModelBusEntryRevisionReference remoteReference = new ModelBusEntryRevisionReference(right.getOriginator().getUrl(), right.getPegRevision(), right.getRevision());
        ThreeWayPropertyCompareInput input = new ThreeWayPropertyCompareInput(new CompareConfiguration(), resource, remoteReference, baseReference, "-1");
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }
}

