/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.merge;

import java.util.Collection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusParticipant;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelbusSubscriber;
import org.modelbus.team.eclipse.ui.synchronize.AbstractSynchronizeActionGroup;
import org.modelbus.team.eclipse.ui.synchronize.merge.MergeScope;
import org.modelbus.team.eclipse.ui.synchronize.merge.MergeSubscriber;
import org.modelbus.team.eclipse.ui.utility.OverlayedImageDescriptor;

public class MergeParticipant
extends AbstractModelBusParticipant {
    public static final String PARTICIPANT_ID = MergeParticipant.class.getName();
    public static final int SUPPORTED_MODES = 15;
    protected IPropertyChangeListener configurationListener;

    public MergeParticipant() {
    }

    public MergeParticipant(ISynchronizeScope scope) {
        super(scope);
    }

    @Override
    public AbstractModelbusSubscriber getMatchingSubscriber() {
        MergeSubscriber subscriber = MergeSubscriber.instance();
        subscriber.setMergeScope((MergeScope)this.getScope());
        return subscriber;
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    protected String getParticipantId() {
        return PARTICIPANT_ID;
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        return ExtensionsManager.getInstance().getCurrentSynchronizeActionContributor().getMergeContributions();
    }

    @Override
    protected int getSupportedModes() {
        return 15;
    }

    @Override
    protected int getDefaultMode() {
        return 4;
    }

    protected String getShortTaskName() {
        return ModelBusTeamUIPlugin.instance().getResource("MergeView.TaskName");
    }

    @Override
    protected ILabelDecorator createLabelDecorator() {
        return new MergeLabelDecorator();
    }

    protected class MergeLabelDecorator
    extends AbstractModelBusParticipant.LabelDecorator {
        @Override
        public Image decorateImage(Image image, Object element) {
            ILocalResource local;
            AbstractModelBusSyncInfo info = this.getSyncInfo(element);
            if (info != null && (info.getKind() & 0xF) == 15 && IStateFilter.SF_PREREPLACEDREPLACED.accept(local = info.getLocalResource())) {
                return this.registerImageDescriptor(new OverlayedImageDescriptor(image, OVR_REPLACED_CONF, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V));
            }
            return super.decorateImage(image, element);
        }
    }
}

