/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.merge;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusMergeStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.AbstractMergeSet;
import org.modelbus.team.eclipse.core.operation.local.IRemoteStatusOperation;
import org.modelbus.team.eclipse.core.operation.local.MergeSet1URL;
import org.modelbus.team.eclipse.core.operation.local.MergeSet2URL;
import org.modelbus.team.eclipse.core.operation.local.MergeSetReintegrate;
import org.modelbus.team.eclipse.core.operation.local.MergeStatusOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.resource.IChangeStateProvider;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelbusSubscriber;
import org.modelbus.team.eclipse.ui.synchronize.RemoteStatusCache;
import org.modelbus.team.eclipse.ui.synchronize.merge.MergeScope;
import org.modelbus.team.eclipse.ui.synchronize.merge.MergeSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSyncInfo;

public class MergeSubscriber
extends AbstractModelbusSubscriber {
    private static MergeSubscriber instance = null;
    protected MergeScope scope;
    protected MergeStatusOperation mergeStatusOp;
    protected RemoteStatusCache baseStatusCache = new RemoteStatusCache();

    public static synchronized MergeSubscriber instance() {
        if (instance == null) {
            instance = new MergeSubscriber();
        }
        return instance;
    }

    public MergeScope getMergeScope() {
        return this.scope;
    }

    public void setMergeScope(MergeScope scope) {
        this.scope = scope;
    }

    @Override
    protected SyncInfo getModelBusSyncInfo(ILocalResource localStatus, IResourceChange remoteStatus) {
        IResourceChange baseStatus = ModelBusRemoteStorage.instance().resourceChangeFromBytes(this.baseStatusCache.getBytes(localStatus.getResource()));
        return remoteStatus != null && IStateFilter.SF_NOTMODIFIED.accept((ILocalResource)remoteStatus) ? new UpdateSyncInfo(localStatus, null, this.getResourceComparator()) : new MergeSyncInfo(localStatus, baseStatus, remoteStatus, this.getResourceComparator());
    }

    @Override
    protected IRemoteStatusOperation addStatusOperation(CompositeOperation op, IResource[] resources, int depth) {
        this.mergeStatusOp = this.scope == null ? null : new MergeStatusOperation(this.scope.getMergeSet(), resources);
        MergeStatusOperation mergeOp = this.mergeStatusOp;
        if (mergeOp == null) {
            return null;
        }
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)mergeOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources, depth, RefreshResourcesOperation.REFRESH_CHANGES));
        return mergeOp;
    }

    @Override
    protected HashSet<IResource> clearRemoteStatusesImpl(IResource[] resources) {
        this.clearRemoteStatusesImpl(this.baseStatusCache, resources);
        return super.clearRemoteStatusesImpl(resources);
    }

    @Override
    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) {
        if (this.scope != null) {
            this.baseStatusCache.clearAll();
            this.scope.getMergeSet().setStatuses(new ModelBusMergeStatus[0]);
        }
        super.refresh(resources, depth, monitor);
    }

    @Override
    protected IResourceChange handleResourceChange(IRemoteStatusOperation rStatusOp, ModelBusEntryStatus status) {
        final ModelBusMergeStatus current = (ModelBusMergeStatus)status;
        IChangeStateProvider endProvider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.date;
            }

            public String getChangeAuthor() {
                return current.author;
            }

            public ModelBusRevision getChangeRevision() {
                return current.endRevision == ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? null : current.endRevision;
            }

            public int getTextChangeType() {
                return current.skipped ? current.textStatus : 1;
            }

            public int getPropertiesChangeType() {
                return current.skipped ? current.propStatus : 0;
            }

            public int getNodeKind() {
                int kind = ModelBusUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)true);
                return kind == 0 ? ModelBusUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return current.comment;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])MergeSubscriber.this.scope.getRoots(), (IResource[])set);
            }
        };
        if (endProvider.getNodeKind() == 0) {
            return null;
        }
        IResourceChange endResourceChange = ModelBusRemoteStorage.instance().asResourceChange(endProvider, false);
        if (endResourceChange == null) {
            return null;
        }
        if (endResourceChange.getRevision() != ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
            IRepositoryResource originator = this.getEndOriginator();
            String decodedUrl = ModelBusUtility.decodeURL((String)current.endUrl);
            originator = endProvider.getNodeKind() == 2 ? originator.asRepositoryContainer(decodedUrl, false) : originator.asRepositoryFile(decodedUrl, false);
            originator.setSelectedRevision(current.textStatus == 4 ? current.endRevision.getPreviousRevision() : current.endRevision);
            endResourceChange.setOriginator(originator);
        }
        IChangeStateProvider startProvider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.date;
            }

            public String getChangeAuthor() {
                return null;
            }

            public ModelBusRevision getChangeRevision() {
                return current.startRevision == ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? null : current.startRevision;
            }

            public int getTextChangeType() {
                return current.startRevision == ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? 0 : 1;
            }

            public int getPropertiesChangeType() {
                return 0;
            }

            public int getNodeKind() {
                int kind = ModelBusUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)true);
                return kind == 0 ? ModelBusUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])MergeSubscriber.this.scope.getRoots(), (IResource[])set);
            }
        };
        IResourceChange startResourceChange = ModelBusRemoteStorage.instance().asResourceChange(startProvider, false);
        if (startResourceChange.getRevision() != ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
            String decodedUrl = ModelBusUtility.decodeURL((String)current.startUrl);
            IRepositoryResource originator = this.getStartOriginator();
            originator = startProvider.getNodeKind() == 2 ? originator.asRepositoryContainer(decodedUrl, false) : originator.asRepositoryFile(decodedUrl, false);
            originator.setSelectedRevision(current.startRevision);
            startResourceChange.setOriginator(originator);
        }
        this.baseStatusCache.setBytes(startResourceChange.getResource(), ModelBusRemoteStorage.instance().resourceChangeAsBytes(startResourceChange));
        return endResourceChange;
    }

    protected IRepositoryResource getEndOriginator() {
        AbstractMergeSet mergeSet = this.scope.getMergeSet();
        if (mergeSet instanceof MergeSet1URL) {
            return ((MergeSet1URL)mergeSet).from[0];
        }
        if (mergeSet instanceof MergeSet2URL) {
            return ((MergeSet2URL)mergeSet).fromEnd[0];
        }
        return ((MergeSetReintegrate)mergeSet).from[0];
    }

    protected IRepositoryResource getStartOriginator() {
        AbstractMergeSet mergeSet = this.scope.getMergeSet();
        if (mergeSet instanceof MergeSet1URL) {
            return ((MergeSet1URL)mergeSet).from[0];
        }
        if (mergeSet instanceof MergeSet2URL) {
            return ((MergeSet2URL)mergeSet).fromStart[0];
        }
        return ((MergeSetReintegrate)mergeSet).from[0];
    }

    @Override
    protected boolean isIncoming(ModelBusEntryStatus status) {
        return true;
    }

    private MergeSubscriber() {
    }
}

