/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.merge;

import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.variant.ResourceVariant;

public class MergeSyncInfo
extends AbstractModelBusSyncInfo {
    public MergeSyncInfo(ILocalResource local, IResourceChange base, IResourceChange remote, IResourceVariantComparator comparator) {
        super(local, base == null ? AbstractModelBusSyncInfo.makeBaseVariant(local) : AbstractModelBusSyncInfo.makeRemoteVariant(local, (ILocalResource)base), AbstractModelBusSyncInfo.makeRemoteVariant(local, (ILocalResource)remote), comparator);
    }

    protected int calculateKind() throws TeamException {
        int remoteMask;
        int localMask;
        String localKind = this.local == null ? IStateFilter.ST_NOTEXISTS : this.local.getStatus();
        int n = localMask = this.local == null ? 0 : this.local.getChangeMask();
        String remoteKind = this.getRemote() == null ? (this.isNonVersioned(localKind, localMask) ? IStateFilter.ST_NOTEXISTS : "Normal") : ((ResourceVariant)this.getRemote()).getStatus();
        int n2 = remoteMask = this.getRemote() == null ? 0 : ((ResourceVariant)this.getRemote()).getResource().getChangeMask();
        if (this.isLinked(localKind, localMask)) {
            if (this.isAdded(remoteKind, remoteMask)) {
                return 13;
            }
            if (this.isModified(remoteKind, remoteMask) || this.isReplaced(remoteKind, remoteMask)) {
                return 15;
            }
            if (this.isDeleted(remoteKind, remoteMask)) {
                return 14;
            }
            return 0;
        }
        if (this.isAdded(remoteKind, remoteMask)) {
            if (this.isNotExists(localKind, localMask) || this.isDeleted(localKind, localMask)) {
                return 9;
            }
            return 13;
        }
        if (this.isConflicted(remoteKind, remoteMask)) {
            return 15;
        }
        if (this.isModified(remoteKind, remoteMask)) {
            if (this.isNotExists(localKind, localMask)) {
                return 9;
            }
            if (this.isDeleted(localKind, localMask)) {
                return 14;
            }
            return 11;
        }
        if (this.isDeleted(remoteKind, remoteMask)) {
            if (this.isNotExists(localKind, localMask) || this.isDeleted(localKind, localMask)) {
                return 0;
            }
            if (this.isNotModified(localKind, localMask)) {
                return 10;
            }
            return 14;
        }
        return 0;
    }
}

