/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.merge.action;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.GetRemoteContentsOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.operation.ClearMergeStatusesOperation;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.action.ISyncStateFilter;
import org.modelbus.team.eclipse.ui.synchronize.variant.RemoteResourceVariant;
import org.modelbus.team.eclipse.ui.synchronize.variant.ResourceVariant;

public class UpdateAction
extends AbstractSynchronizeModelAction {
    protected boolean advancedMode;

    public UpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.advancedMode = false;
    }

    public UpdateAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.advancedMode = true;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 4}){

            public boolean select(SyncInfo info) {
                return super.select(info) && !IStateFilter.SF_OBSTRUCTED.accept(((AbstractModelBusSyncInfo)info).getLocalResource());
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] allResources = this.syncInfoSelector.getSelectedResources();
        if (this.advancedMode) {
            String message = allResources.length == 1 ? ModelBusTeamUIPlugin.instance().getResource("AcceptAll.Message.Single") : ModelBusTeamUIPlugin.instance().getResource("AcceptAll.Message.Multi", new String[]{String.valueOf(allResources.length)});
            MessageDialog dlg = new MessageDialog(configuration.getSite().getShell(), ModelBusTeamUIPlugin.instance().getResource("AcceptAll.Title"), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dlg.open() != 0) {
                return null;
            }
        }
        AbstractModelBusSyncInfo[] infos = this.getModelBusSyncInfos();
        HashMap<String, String> remote2local = new HashMap<String, String>();
        ArrayList<IRepositoryResource> remoteSet = new ArrayList<IRepositoryResource>();
        ArrayList<IResource> localSet = new ArrayList<IResource>();
        int i = 0;
        while (i < infos.length) {
            ILocalResource remote = ((ResourceVariant)infos[i].getRemote()).getResource();
            if (remote instanceof IResourceChange && ISyncStateFilter.SF_ONREPOSITORY.acceptRemote(remote.getResource(), remote.getStatus(), remote.getChangeMask())) {
                IResource resource = infos[i].getLocal();
                localSet.add(resource);
                IRepositoryResource remoteResource = ((IResourceChange)((RemoteResourceVariant)infos[i].getRemote()).getResource()).getOriginator();
                remoteSet.add(remoteResource);
                remote2local.put(ModelBusUtility.encodeURL((String)remoteResource.getUrl()), FileUtility.getWorkingCopyPath((IResource)resource));
            }
            ++i;
        }
        IResource[] resources = localSet.toArray(new IResource[localSet.size()]);
        if (resources.length > 0) {
            GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(resources, remoteSet.toArray(new IRepositoryResource[remoteSet.size()]), remote2local);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            op.add((IActionOperation)new ClearMergeStatusesOperation(allResources));
            return op;
        }
        return new ClearMergeStatusesOperation(allResources);
    }
}

