/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusChangeStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.IRemoteStatusOperation;
import org.modelbus.team.eclipse.core.operation.local.RemoteStatusOperation;
import org.modelbus.team.eclipse.core.operation.remote.GetLogMessagesOperation;
import org.modelbus.team.eclipse.core.resource.IChangeStateProvider;
import org.modelbus.team.eclipse.core.resource.ICommentProvider;
import org.modelbus.team.eclipse.core.resource.IFileChange;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IResourceChange;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelbusSubscriber;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSyncInfo;

public class UpdateSubscriber
extends AbstractModelbusSubscriber {
    private static UpdateSubscriber instance = null;
    protected Map<ModelBusRevision, String> comments = new HashMap<ModelBusRevision, String>();

    public static synchronized UpdateSubscriber instance() {
        if (instance == null) {
            instance = new UpdateSubscriber();
        }
        return instance;
    }

    @Override
    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) {
        this.comments.clear();
        super.refresh(resources, depth, monitor);
    }

    @Override
    protected IRemoteStatusOperation addStatusOperation(CompositeOperation op, IResource[] resources, int depth) {
        RemoteStatusOperation rStatus = new RemoteStatusOperation(resources);
        op.add((IActionOperation)rStatus);
        return rStatus;
    }

    @Override
    protected SyncInfo getModelBusSyncInfo(ILocalResource localStatus, IResourceChange remoteStatus) {
        return new UpdateSyncInfo(localStatus, remoteStatus, this.getResourceComparator());
    }

    @Override
    protected IResourceChange handleResourceChange(IRemoteStatusOperation rStatusOp, ModelBusEntryStatus status) {
        final ModelBusChangeStatus current = (ModelBusChangeStatus)status;
        if (current.textStatus == 13) {
            return null;
        }
        final IResource[] scope = rStatusOp.getScope();
        IChangeStateProvider provider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.reposLastCmtRevision == ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? current.lastChangedDate : current.reposLastCmtDate;
            }

            public String getChangeAuthor() {
                return current.reposLastCmtRevision == ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? current.lastCommitAuthor : current.reposLastCmtAuthor;
            }

            public ModelBusRevision getChangeRevision() {
                ModelBusRevision changeRev = ModelBusRevision.INVALID_REVISION_DESCRIPTOR.equals((Object)current.reposLastCmtRevision) ? current.lastChangedRevision : current.reposLastCmtRevision;
                return "-1".equals(changeRev) ? null : changeRev;
            }

            public int getTextChangeType() {
                return current.repositoryTextStatus;
            }

            public int getPropertiesChangeType() {
                return current.repositoryPropStatus;
            }

            public int getNodeKind() {
                int kind = ModelBusUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)true);
                return kind == 0 ? ModelBusUtility.getNodeKind((String)current.path, (int)current.reposKind, (boolean)true) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return current.isCopied;
            }

            public boolean isSwitched() {
                return current.isSwitched;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])scope, (IResource[])set);
            }
        };
        if (provider.getNodeKind() == 0) {
            return null;
        }
        IResourceChange resourceChange = ModelBusRemoteStorage.instance().asResourceChange(provider, true);
        if (resourceChange == null || resourceChange.getRevision() == ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
            return null;
        }
        IResourceChange checkForReplacement = ModelBusRemoteStorage.instance().resourceChangeFromBytes(this.statusCache.getBytes(resourceChange.getResource()));
        if (checkForReplacement != null) {
            if (IStateFilter.SF_ADDED.accept((ILocalResource)checkForReplacement)) {
                if (IStateFilter.SF_DELETED.accept((ILocalResource)resourceChange)) {
                    checkForReplacement.treatAsReplacement();
                }
                return checkForReplacement;
            }
            if (IStateFilter.SF_DELETED.accept((ILocalResource)checkForReplacement) && IStateFilter.SF_ADDED.accept((ILocalResource)resourceChange)) {
                resourceChange.treatAsReplacement();
            }
        }
        rStatusOp.setPegRevision(resourceChange);
        IRepositoryResource originator = ModelBusRemoteStorage.instance().asRepositoryResource(resourceChange.getResource());
        if (originator != null) {
            IRepositoryFile tOriginator;
            String url = ModelBusUtility.decodeURL((String)current.url);
            Object object = tOriginator = resourceChange instanceof IFileChange ? originator.asRepositoryFile(url, true) : originator.asRepositoryContainer(url, true);
            if (tOriginator != null) {
                originator = tOriginator;
            }
            originator.setSelectedRevision(resourceChange.getRevision());
            originator.setPegRevision(resourceChange.getPegRevision());
            resourceChange.setOriginator(originator);
        }
        resourceChange.setCommentProvider(new ICommentProvider(){

            public String getComment(IResource resource, ModelBusRevision rev, ModelBusRevision peg) {
                if (!UpdateSubscriber.this.comments.containsKey(rev)) {
                    this.cacheComments(resource, rev, peg);
                }
                return UpdateSubscriber.this.comments.get(rev);
            }

            public void cacheComments(IResource resource, ModelBusRevision rev, ModelBusRevision peg) {
                if (rev == ModelBusRevision.INVALID_REVISION_DESCRIPTOR || peg != null && peg == ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
                    return;
                }
                IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(resource).getRoot();
                remote.setSelectedRevision(rev);
                remote.setPegRevision(peg);
                GetLogMessagesOperation op = new GetLogMessagesOperation(remote);
                op.setLimit(20L);
                op.setDiscoverPaths(false);
                ProgressMonitorUtility.doTaskExternalDefault((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
                if (op.getExecutionState() == 0) {
                    ModelBusLogEntry[] modelBusLogEntryArray = op.getMessages();
                    int n = modelBusLogEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModelBusLogEntry entry = modelBusLogEntryArray[n2];
                        UpdateSubscriber.this.comments.put(ModelBusRevision.fromString((String)entry.revision), entry.message);
                        ++n2;
                    }
                }
            }
        });
        return resourceChange;
    }

    @Override
    protected boolean isIncoming(ModelBusEntryStatus status) {
        ModelBusChangeStatus st = (ModelBusChangeStatus)status;
        return st.repositoryPropStatus == 2 || st.repositoryTextStatus != 0;
    }

    private UpdateSubscriber() {
    }
}

