/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.AddToModelBusIgnoreOperation;
import org.modelbus.team.eclipse.core.operation.local.AddToModelBusOperation;
import org.modelbus.team.eclipse.core.operation.local.ClearLocalStatusesOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.panel.local.AbstractResourceSelectionPanel;
import org.modelbus.team.eclipse.ui.panel.local.AddToModelBusPanel;
import org.modelbus.team.eclipse.ui.panel.local.IgnoreMethodPanel;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSyncInfo;

public class AddToModelBusIgnoreAction
extends AbstractSynchronizeModelAction {
    protected static IStateFilter SF_NEW_AND_PARENT_VERSIONED = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            if (state == "New") {
                return IStateFilter.SF_VERSIONED.accept(ModelBusRemoteStorage.instance().asLocalResource((IResource)resource.getParent()));
            }
            return false;
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public AddToModelBusIgnoreAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                UpdateSyncInfo sync = (UpdateSyncInfo)info;
                return SF_NEW_AND_PARENT_VERSIONED.accept(sync.getLocalResource());
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        AbstractDialogPanel panel;
        IResource[] resources = FileUtility.shrinkChildNodes((IResource[])this.syncInfoSelector.getSelectedResources());
        IResource[] operableParents = FileUtility.getOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_UNVERSIONED);
        if (operableParents.length > 0) {
            panel = new AddToModelBusPanel(operableParents);
            DefaultDialog dialog1 = new DefaultDialog(configuration.getSite().getShell(), panel);
            if (dialog1.open() != 0) {
                return null;
            }
            operableParents = ((AbstractResourceSelectionPanel)panel).getSelectedResources();
        }
        panel = new IgnoreMethodPanel(resources);
        DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
        if (dialog.open() != 0) {
            return null;
        }
        AddToModelBusIgnoreOperation mainOp = new AddToModelBusIgnoreOperation(resources, ((IgnoreMethodPanel)panel).getIgnoreType(), ((IgnoreMethodPanel)panel).getIgnorePattern());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        if (operableParents.length > 0) {
            op.add((IActionOperation)new AddToModelBusOperation(operableParents));
            op.add((IActionOperation)new ClearLocalStatusesOperation(operableParents));
        }
        op.add((IActionOperation)mainOp);
        HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            tmp.add((IResource)resources[i].getParent());
            ++i;
        }
        IResource[] resourcesAndParents = tmp.toArray(new IResource[tmp.size()]);
        op.add((IActionOperation)new RefreshResourcesOperation(resourcesAndParents, 2, RefreshResourcesOperation.REFRESH_ALL));
        return op;
    }
}

