/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update.action;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.LockOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.local.CommitPanel;
import org.modelbus.team.eclipse.ui.panel.local.LockPanel;
import org.modelbus.team.eclipse.ui.synchronize.AbstractModelBusSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;

public class LockAction
extends AbstractSynchronizeModelAction {
    public LockAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return super.select(info) && IStateFilter.SF_READY_TO_LOCK.accept(((AbstractModelBusSyncInfo)info).getLocalResource());
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] selectedResources = this.syncInfoSelector.getSelectedResources();
        CommitPanel.CollectPropertiesOperation cop = new CommitPanel.CollectPropertiesOperation(selectedResources);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)cop, null);
        LockPanel commentPanel = new LockPanel(true, cop.getMinLockSize());
        DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), commentPanel);
        if (dialog.open() == 0) {
            LockOperation mainOp = new LockOperation(selectedResources, commentPanel.getMessage(), commentPanel.getForce());
            CompositeOperation lockOp = new CompositeOperation(mainOp.getId());
            lockOp.add((IActionOperation)mainOp);
            lockOp.add((IActionOperation)new RefreshResourcesOperation(selectedResources));
            return lockOp;
        }
        return null;
    }
}

