/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update.action;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.MarkAsMergedOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.resource.ILocalFile;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.operation.ClearUpdateStatusesOperation;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSyncInfo;
import org.modelbus.team.eclipse.ui.synchronize.variant.ResourceVariant;
import org.modelbus.team.eclipse.ui.utility.UnacceptableOperationNotificator;

public class MarkAsMergedAction
extends AbstractSynchronizeModelAction {
    public MarkAsMergedAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    UpdateSyncInfo sync = (UpdateSyncInfo)info;
                    boolean localIsFile = sync.getLocalResource().getResource() instanceof IFile;
                    boolean remoteIsFile = ((ResourceVariant)sync.getRemote()).getResource() instanceof ILocalFile;
                    return !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocalResource()) && localIsFile == remoteIsFile;
                }
                return false;
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(configuration.getSite().getShell(), this.syncInfoSelector.getSelectedResources());
        if (resources == null || resources.length == 0) {
            return null;
        }
        MarkAsMergedOperation mainOp = new MarkAsMergedOperation(resources, false, null);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources));
        op.add((IActionOperation)new RefreshResourcesOperation(FileUtility.getParents((IResource[])resources, (boolean)false)));
        return op;
    }
}

