/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IRevisionProvider;
import org.modelbus.team.eclipse.core.operation.local.AddToModelBusWithPropertiesOperation;
import org.modelbus.team.eclipse.core.operation.local.ClearLocalStatusesOperation;
import org.modelbus.team.eclipse.core.operation.local.CommitOperation;
import org.modelbus.team.eclipse.core.operation.local.MarkAsMergedOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.dialog.NotifyNodeKindChangedDialog;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.extension.factory.ICommitDialog;
import org.modelbus.team.eclipse.ui.operation.ClearUpdateStatusesOperation;
import org.modelbus.team.eclipse.ui.panel.local.CommitPanel;
import org.modelbus.team.eclipse.ui.synchronize.ModelBusChangeSetCapability;
import org.modelbus.team.eclipse.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.modelbus.team.eclipse.ui.synchronize.action.ISyncStateFilter;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSyncInfo;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.utility.UnacceptableOperationNotificator;

public class OverrideAndCommitAction
extends AbstractSynchronizeModelAction {
    public static final IStateFilter SF_NEW = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state == "New";
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public OverrideAndCommitAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12, 4}){

            public boolean select(SyncInfo info) {
                UpdateSyncInfo sync = (UpdateSyncInfo)info;
                return super.select(info) && !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocalResource());
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        String msg = null;
        boolean keepLocks = false;
        final IResource[][] resources = new IResource[1][];
        IResource[] changedResources = this.syncInfoSelector.getSelectedResourcesRecursive(ISyncStateFilter.SF_OVERRIDE);
        IResource[] overrideResources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(configuration.getSite().getShell(), changedResources);
        if (overrideResources != null && overrideResources.length > 0) {
            overrideResources = FileUtility.addOperableParents((IResource[])overrideResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
            HashSet<IResource> allResourcesSet = new HashSet<IResource>(Arrays.asList(overrideResources));
            String proposedComment = ModelBusChangeSetCapability.getProposedComment(overrideResources);
            CommitPanel commitPanel = new CommitPanel(overrideResources, overrideResources, 1, proposedComment);
            ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(configuration.getSite().getShell(), allResourcesSet, commitPanel);
            if (commitDialog.open() != 0) {
                return null;
            }
            resources[0] = commitPanel.getSelectedResources().length == 0 ? null : commitPanel.getSelectedResources();
            msg = commitDialog.getMessage();
            keepLocks = commitPanel.getKeepLocks();
        }
        CompositeOperation op = new CompositeOperation("Operation.UOverrideAndCommit");
        final MarkAsMergedOperation mergeOp = new MarkAsMergedOperation(resources[0], true, msg, keepLocks);
        op.add((IActionOperation)mergeOp);
        final IResource[] addition = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)SF_NEW);
        if (addition.length != 0) {
            IResourceProvider additionProvider = new IResourceProvider(){
                protected IResource[] result;

                public IResource[] getResources() {
                    if (this.result == null) {
                        HashSet<IResource> tAdd = new HashSet<IResource>(Arrays.asList(addition));
                        IResource[] restricted = mergeOp.getHavingDifferentNodeKind();
                        int i = 0;
                        while (i < restricted.length) {
                            if (restricted[i] instanceof IContainer) {
                                IResource[] restrictedChildren = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_ALL);
                                tAdd.removeAll(Arrays.asList(restrictedChildren));
                            } else {
                                tAdd.remove(restricted[i]);
                            }
                            ++i;
                        }
                        this.result = tAdd.toArray(new IResource[tAdd.size()]);
                    }
                    return this.result;
                }
            };
            op.add((IActionOperation)new AddToModelBusWithPropertiesOperation(additionProvider, false), new IActionOperation[]{mergeOp});
            op.add((IActionOperation)new ClearLocalStatusesOperation(additionProvider));
        }
        CommitOperation mainOp = new CommitOperation((IResourceProvider)mergeOp, msg, true, keepLocks);
        IActionOperation[] dependsOn = new IActionOperation[]{mergeOp};
        op.add((IActionOperation)mainOp, dependsOn);
        op.add((IActionOperation)new AbstractActionOperation("Operation.UNodeKindChanged"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                final IResource[] diffNodeKind = mergeOp.getHavingDifferentNodeKind();
                if (diffNodeKind.length > 0) {
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            new NotifyNodeKindChangedDialog(UIMonitorUtility.getShell(), diffNodeKind).open();
                        }
                    });
                }
            }
        });
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources[0]));
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        ExtensionsManager.getInstance().getCurrentCommitFactory().performAfterCommitTasks(op, (IRevisionProvider)mainOp, dependsOn, configuration.getSite().getPart());
        return op;
    }
}

